/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jce.provider.JCERSAPrivateKey;

public final class JCERSAPrivateCrtKey
extends JCERSAPrivateKey
implements RSAPrivateCrtKey {
    private BigInteger publicExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;

    JCERSAPrivateCrtKey(RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters) {
        super(rSAPrivateCrtKeyParameters);
        this.publicExponent = rSAPrivateCrtKeyParameters.getPublicExponent();
        this.primeP = rSAPrivateCrtKeyParameters.getP();
        this.primeQ = rSAPrivateCrtKeyParameters.getQ();
        this.primeExponentP = rSAPrivateCrtKeyParameters.getDP();
        this.primeExponentQ = rSAPrivateCrtKeyParameters.getDQ();
        this.crtCoefficient = rSAPrivateCrtKeyParameters.getQInv();
    }

    @Override
    public final String getFormat() {
        return "PKCS#8";
    }

    @Override
    public final byte[] getEncoded() {
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull()), new RSAPrivateKeyStructure(this.getModulus(), this.getPublicExponent(), this.getPrivateExponent(), this.getPrimeP(), this.getPrimeQ(), this.getPrimeExponentP(), this.getPrimeExponentQ(), this.getCrtCoefficient()).getDERObject());
        return privateKeyInfo.getDEREncoded();
    }

    @Override
    public final BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public final BigInteger getPrimeP() {
        return this.primeP;
    }

    @Override
    public final BigInteger getPrimeQ() {
        return this.primeQ;
    }

    @Override
    public final BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    @Override
    public final BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    @Override
    public final BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    @Override
    public final int hashCode() {
        return this.getModulus().hashCode() ^ this.getPublicExponent().hashCode() ^ this.getPrivateExponent().hashCode();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RSAPrivateCrtKey)) {
            return false;
        }
        object = (RSAPrivateCrtKey)object;
        return this.getModulus().equals(object.getModulus()) && this.getPublicExponent().equals(object.getPublicExponent()) && this.getPrivateExponent().equals(object.getPrivateExponent()) && this.getPrimeP().equals(object.getPrimeP()) && this.getPrimeQ().equals(object.getPrimeQ()) && this.getPrimeExponentP().equals(object.getPrimeExponentP()) && this.getPrimeExponentQ().equals(object.getPrimeExponentQ()) && this.getCrtCoefficient().equals(object.getCrtCoefficient());
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("RSA Private CRT Key").append(string);
        stringBuffer.append("            modulus: ").append(this.getModulus().toString(16)).append(string);
        stringBuffer.append("    public exponent: ").append(this.getPublicExponent().toString(16)).append(string);
        stringBuffer.append("   private exponent: ").append(this.getPrivateExponent().toString(16)).append(string);
        stringBuffer.append("             primeP: ").append(this.getPrimeP().toString(16)).append(string);
        stringBuffer.append("             primeQ: ").append(this.getPrimeQ().toString(16)).append(string);
        stringBuffer.append("     primeExponentP: ").append(this.getPrimeExponentP().toString(16)).append(string);
        stringBuffer.append("     primeExponentQ: ").append(this.getPrimeExponentQ().toString(16)).append(string);
        stringBuffer.append("     crtCoefficient: ").append(this.getCrtCoefficient().toString(16)).append(string);
        return stringBuffer.toString();
    }
}

