/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.Map;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;

public final class BouncyCastleProvider
extends Provider {
    private static String info = "BouncyCastle Security Provider v1.45";
    private static String PROVIDER_NAME = "BC";
    private static final String[] SYMMETRIC_CIPHERS = new String[]{"AES", "Camellia", "CAST5", "Grainv1", "Grain128", "IDEA", "Noekeon", "SEED"};
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"EC"};

    public BouncyCastleProvider() {
        super(PROVIDER_NAME, 1.45, info);
        AccessController.doPrivileged(new PrivilegedAction(this){
            private /* synthetic */ BouncyCastleProvider this$0;
            {
                this.this$0 = bouncyCastleProvider;
            }

            public final Object run() {
                BouncyCastleProvider.access$000(this.this$0);
                return null;
            }
        });
    }

    private void loadAlgorithms(String string, String[] stringArray) {
        for (int i = 0; i != stringArray.length; ++i) {
            Class<?> clazz = null;
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                clazz = classLoader != null ? classLoader.loadClass(string + stringArray[i] + "Mappings") : Class.forName(string + stringArray[i] + "Mappings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) continue;
            try {
                this.addMappings((Map)clazz.newInstance());
                continue;
            }
            catch (Exception exception) {
                throw new InternalError("cannot create instance of " + string + stringArray[i] + "Mappings : " + exception);
            }
        }
    }

    private void addMappings(Map map) {
        for (Object k : map.keySet()) {
            if (this.containsKey(k)) {
                throw new IllegalStateException("duplicate provider key (" + k + ") found in " + map.getClass().getName());
            }
            this.put(k, map.get(k));
        }
    }

    private void addHMACAlgorithm(String string, String string2, String string3) {
        String string4 = "HMAC" + string;
        this.put("Mac." + string4, string2);
        this.put("Alg.Alias.Mac.HMAC-" + string, string4);
        this.put("Alg.Alias.Mac.HMAC/" + string, string4);
        this.put("KeyGenerator." + string4, string3);
        this.put("Alg.Alias.KeyGenerator.HMAC-" + string, string4);
        this.put("Alg.Alias.KeyGenerator.HMAC/" + string, string4);
    }

    private void addHMACAlias(String string, DERObjectIdentifier dERObjectIdentifier) {
        string = "HMAC" + string;
        this.put("Alg.Alias.Mac." + dERObjectIdentifier, string);
        this.put("Alg.Alias.KeyGenerator." + dERObjectIdentifier, string);
    }

    private void addSignatureAlgorithms() {
        this.put("Signature.MD2WithRSAEncryption", "org.bouncycastle.jce.provider.JDKDigestSignature$MD2WithRSAEncryption");
        this.put("Signature.MD4WithRSAEncryption", "org.bouncycastle.jce.provider.JDKDigestSignature$MD4WithRSAEncryption");
        this.put("Signature.MD5WithRSAEncryption", "org.bouncycastle.jce.provider.JDKDigestSignature$MD5WithRSAEncryption");
        this.put("Signature.SHA1WithRSAEncryption", "org.bouncycastle.jce.provider.JDKDigestSignature$SHA1WithRSAEncryption");
        this.put("Signature.SHA224WithRSAEncryption", "org.bouncycastle.jce.provider.JDKDigestSignature$SHA224WithRSAEncryption");
        this.put("Signature.SHA256WithRSAEncryption", "org.bouncycastle.jce.provider.JDKDigestSignature$SHA256WithRSAEncryption");
        this.put("Signature.SHA384WithRSAEncryption", "org.bouncycastle.jce.provider.JDKDigestSignature$SHA384WithRSAEncryption");
        this.put("Signature.SHA512WithRSAEncryption", "org.bouncycastle.jce.provider.JDKDigestSignature$SHA512WithRSAEncryption");
        this.put("Signature.RIPEMD160WithRSAEncryption", "org.bouncycastle.jce.provider.JDKDigestSignature$RIPEMD160WithRSAEncryption");
        this.put("Signature.RIPEMD128WithRSAEncryption", "org.bouncycastle.jce.provider.JDKDigestSignature$RIPEMD128WithRSAEncryption");
        this.put("Signature.RIPEMD256WithRSAEncryption", "org.bouncycastle.jce.provider.JDKDigestSignature$RIPEMD256WithRSAEncryption");
        this.put("Signature.DSA", "org.bouncycastle.jce.provider.JDKDSASigner$stdDSA");
        this.put("Signature.NONEWITHDSA", "org.bouncycastle.jce.provider.JDKDSASigner$noneDSA");
        this.put("Signature.SHA1withRSA/ISO9796-2", "org.bouncycastle.jce.provider.JDKISOSignature$SHA1WithRSAEncryption");
        this.put("Signature.MD5withRSA/ISO9796-2", "org.bouncycastle.jce.provider.JDKISOSignature$MD5WithRSAEncryption");
        this.put("Signature.RIPEMD160withRSA/ISO9796-2", "org.bouncycastle.jce.provider.JDKISOSignature$RIPEMD160WithRSAEncryption");
        this.put("Signature.RSASSA-PSS", "org.bouncycastle.jce.provider.JDKPSSSigner$PSSwithRSA");
        this.put("Signature." + PKCSObjectIdentifiers.id_RSASSA_PSS, "org.bouncycastle.jce.provider.JDKPSSSigner$PSSwithRSA");
        this.put("Signature.SHA1withRSA/PSS", "org.bouncycastle.jce.provider.JDKPSSSigner$SHA1withRSA");
        this.put("Signature.SHA224withRSA/PSS", "org.bouncycastle.jce.provider.JDKPSSSigner$SHA224withRSA");
        this.put("Signature.SHA256withRSA/PSS", "org.bouncycastle.jce.provider.JDKPSSSigner$SHA256withRSA");
        this.put("Signature.SHA384withRSA/PSS", "org.bouncycastle.jce.provider.JDKPSSSigner$SHA384withRSA");
        this.put("Signature.SHA512withRSA/PSS", "org.bouncycastle.jce.provider.JDKPSSSigner$SHA512withRSA");
        this.put("Signature.RSA", "org.bouncycastle.jce.provider.JDKDigestSignature$noneRSA");
        this.put("Signature.RAWRSASSA-PSS", "org.bouncycastle.jce.provider.JDKPSSSigner$nonePSS");
        this.put("Alg.Alias.Signature.RAWDSA", "NONEWITHDSA");
        this.put("Alg.Alias.Signature.RAWRSA", "RSA");
        this.put("Alg.Alias.Signature.NONEWITHRSA", "RSA");
        this.put("Alg.Alias.Signature.RAWRSAPSS", "RAWRSASSA-PSS");
        this.put("Alg.Alias.Signature.NONEWITHRSAPSS", "RAWRSASSA-PSS");
        this.put("Alg.Alias.Signature.NONEWITHRSASSA-PSS", "RAWRSASSA-PSS");
        this.put("Alg.Alias.Signature.RSAPSS", "RSASSA-PSS");
        this.put("Alg.Alias.Signature.SHA1withRSAandMGF1", "SHA1withRSA/PSS");
        this.put("Alg.Alias.Signature.SHA224withRSAandMGF1", "SHA224withRSA/PSS");
        this.put("Alg.Alias.Signature.SHA256withRSAandMGF1", "SHA256withRSA/PSS");
        this.put("Alg.Alias.Signature.SHA384withRSAandMGF1", "SHA384withRSA/PSS");
        this.put("Alg.Alias.Signature.SHA512withRSAandMGF1", "SHA512withRSA/PSS");
        this.put("Alg.Alias.Signature.MD2withRSAEncryption", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD4withRSAEncryption", "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5withRSAEncryption", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1withRSAEncryption", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA224withRSAEncryption", "SHA224WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256withRSAEncryption", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384withRSAEncryption", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512withRSAEncryption", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256WithRSAEncryption", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384WithRSAEncryption", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512WithRSAEncryption", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256WITHRSAENCRYPTION", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384WITHRSAENCRYPTION", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512WITHRSAENCRYPTION", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD160withRSAEncryption", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.md2WithRSAEncryption, "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD2WithRSA", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD2withRSA", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD2/RSA", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5WithRSA", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5withRSA", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5/RSA", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.md5WithRSAEncryption, "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD4WithRSA", "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD4withRSA", "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD4/RSA", "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.md4WithRSAEncryption, "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1WithRSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1withRSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA224WithRSA", "SHA224WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA224withRSA", "SHA224WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256WithRSA", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256withRSA", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384WithRSA", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384withRSA", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512WithRSA", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512withRSA", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1/RSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA-1/RSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha224WithRSAEncryption, "SHA224WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.113549.1.1.1", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.113549.1.1.5", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.2.840.113549.2.5with1.2.840.113549.1.1.1", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD160WithRSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD160withRSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD128WithRSA", "RIPEMD128WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD128withRSA", "RIPEMD128WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD256WithRSA", "RIPEMD256WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD256withRSA", "RIPEMD256WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD-160/RSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.RMD160withRSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.RMD160/RSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.3.36.3.3.1.2", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.3.36.3.3.1.3", "RIPEMD128WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.3.36.3.3.1.4", "RIPEMD256WithRSAEncryption");
        this.put("Alg.Alias.Signature." + OIWObjectIdentifiers.sha1WithRSA, "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD2WITHRSAENCRYPTION", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5WITHRSAENCRYPTION", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1WITHRSAENCRYPTION", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD160WITHRSAENCRYPTION", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5WITHRSA", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1WITHRSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD160WITHRSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.RMD160WITHRSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD160WITHRSA", "RIPEMD160WithRSAEncryption");
        this.addSignatureAlgorithm("SHA224", "DSA", "org.bouncycastle.jce.provider.JDKDSASigner$dsa224", NISTObjectIdentifiers.dsa_with_sha224);
        this.addSignatureAlgorithm("SHA256", "DSA", "org.bouncycastle.jce.provider.JDKDSASigner$dsa256", NISTObjectIdentifiers.dsa_with_sha256);
        this.addSignatureAlgorithm("SHA384", "DSA", "org.bouncycastle.jce.provider.JDKDSASigner$dsa384", NISTObjectIdentifiers.dsa_with_sha384);
        this.addSignatureAlgorithm("SHA512", "DSA", "org.bouncycastle.jce.provider.JDKDSASigner$dsa512", NISTObjectIdentifiers.dsa_with_sha512);
        this.put("Alg.Alias.Signature.SHA/DSA", "DSA");
        this.put("Alg.Alias.Signature.SHA1withDSA", "DSA");
        this.put("Alg.Alias.Signature.SHA1WITHDSA", "DSA");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.10040.4.1", "DSA");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.10040.4.3", "DSA");
        this.put("Alg.Alias.Signature.DSAwithSHA1", "DSA");
        this.put("Alg.Alias.Signature.DSAWITHSHA1", "DSA");
        this.put("Alg.Alias.Signature.SHA1WithDSA", "DSA");
        this.put("Alg.Alias.Signature.DSAWithSHA1", "DSA");
        this.put("Alg.Alias.Signature.1.2.840.10040.4.3", "DSA");
        this.put("Alg.Alias.Signature.MD5WithRSA/ISO9796-2", "MD5withRSA/ISO9796-2");
        this.put("Alg.Alias.Signature.SHA1WithRSA/ISO9796-2", "SHA1withRSA/ISO9796-2");
        this.put("Alg.Alias.Signature.RIPEMD160WithRSA/ISO9796-2", "RIPEMD160withRSA/ISO9796-2");
        this.put("Signature.ECGOST3410", "org.bouncycastle.jce.provider.JDKGOST3410Signer$ecgost3410");
        this.put("Alg.Alias.Signature.ECGOST-3410", "ECGOST3410");
        this.put("Alg.Alias.Signature.GOST-3410-2001", "ECGOST3410");
        this.put("Alg.Alias.Signature.GOST3411withECGOST3410", "ECGOST3410");
        this.put("Alg.Alias.Signature.GOST3411WITHECGOST3410", "ECGOST3410");
        this.put("Alg.Alias.Signature.GOST3411WithECGOST3410", "ECGOST3410");
        this.put("Alg.Alias.Signature." + CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, "ECGOST3410");
        this.put("Signature.GOST3410", "org.bouncycastle.jce.provider.JDKGOST3410Signer$gost3410");
        this.put("Alg.Alias.Signature.GOST-3410", "GOST3410");
        this.put("Alg.Alias.Signature.GOST-3410-94", "GOST3410");
        this.put("Alg.Alias.Signature.GOST3411withGOST3410", "GOST3410");
        this.put("Alg.Alias.Signature.GOST3411WITHGOST3410", "GOST3410");
        this.put("Alg.Alias.Signature.GOST3411WithGOST3410", "GOST3410");
        this.put("Alg.Alias.Signature." + CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94, "GOST3410");
    }

    private void addSignatureAlgorithm(String string, String string2, String string3, DERObjectIdentifier dERObjectIdentifier) {
        String string4 = string + "WITH" + string2;
        String string5 = string + "with" + string2;
        String string6 = string + "With" + string2;
        string = string + "/" + string2;
        this.put("Signature." + string4, string3);
        this.put("Alg.Alias.Signature." + string5, string4);
        this.put("Alg.Alias.Signature." + string6, string4);
        this.put("Alg.Alias.Signature." + string, string4);
        this.put("Alg.Alias.Signature." + dERObjectIdentifier, string4);
        this.put("Alg.Alias.Signature.OID." + dERObjectIdentifier, string4);
    }

    static /* synthetic */ void access$000(BouncyCastleProvider bouncyCastleProvider) {
        bouncyCastleProvider.loadAlgorithms("org.bouncycastle.jce.provider.symmetric.", SYMMETRIC_CIPHERS);
        bouncyCastleProvider.loadAlgorithms("org.bouncycastle.jce.provider.asymmetric.", ASYMMETRIC_CIPHERS);
        bouncyCastleProvider.put("X509Store.CERTIFICATE/COLLECTION", "org.bouncycastle.jce.provider.X509StoreCertCollection");
        bouncyCastleProvider.put("X509Store.ATTRIBUTECERTIFICATE/COLLECTION", "org.bouncycastle.jce.provider.X509StoreAttrCertCollection");
        bouncyCastleProvider.put("X509Store.CRL/COLLECTION", "org.bouncycastle.jce.provider.X509StoreCRLCollection");
        bouncyCastleProvider.put("X509Store.CERTIFICATEPAIR/COLLECTION", "org.bouncycastle.jce.provider.X509StoreCertPairCollection");
        bouncyCastleProvider.put("X509Store.CERTIFICATE/LDAP", "org.bouncycastle.jce.provider.X509StoreLDAPCerts");
        bouncyCastleProvider.put("X509Store.CRL/LDAP", "org.bouncycastle.jce.provider.X509StoreLDAPCRLs");
        bouncyCastleProvider.put("X509Store.ATTRIBUTECERTIFICATE/LDAP", "org.bouncycastle.jce.provider.X509StoreLDAPAttrCerts");
        bouncyCastleProvider.put("X509Store.CERTIFICATEPAIR/LDAP", "org.bouncycastle.jce.provider.X509StoreLDAPCertPairs");
        bouncyCastleProvider.put("X509StreamParser.CERTIFICATE", "org.bouncycastle.jce.provider.X509CertParser");
        bouncyCastleProvider.put("X509StreamParser.ATTRIBUTECERTIFICATE", "org.bouncycastle.jce.provider.X509AttrCertParser");
        bouncyCastleProvider.put("X509StreamParser.CRL", "org.bouncycastle.jce.provider.X509CRLParser");
        bouncyCastleProvider.put("X509StreamParser.CERTIFICATEPAIR", "org.bouncycastle.jce.provider.X509CertPairParser");
        bouncyCastleProvider.put("KeyStore.BKS", "org.bouncycastle.jce.provider.JDKKeyStore");
        bouncyCastleProvider.put("KeyStore.BouncyCastle", "org.bouncycastle.jce.provider.JDKKeyStore$BouncyCastleStore");
        bouncyCastleProvider.put("KeyStore.PKCS12", "org.bouncycastle.jce.provider.JDKPKCS12KeyStore$BCPKCS12KeyStore");
        bouncyCastleProvider.put("KeyStore.BCPKCS12", "org.bouncycastle.jce.provider.JDKPKCS12KeyStore$BCPKCS12KeyStore");
        bouncyCastleProvider.put("KeyStore.PKCS12-DEF", "org.bouncycastle.jce.provider.JDKPKCS12KeyStore$DefPKCS12KeyStore");
        bouncyCastleProvider.put("KeyStore.PKCS12-3DES-40RC2", "org.bouncycastle.jce.provider.JDKPKCS12KeyStore$BCPKCS12KeyStore");
        bouncyCastleProvider.put("KeyStore.PKCS12-3DES-3DES", "org.bouncycastle.jce.provider.JDKPKCS12KeyStore$BCPKCS12KeyStore3DES");
        bouncyCastleProvider.put("KeyStore.PKCS12-DEF-3DES-40RC2", "org.bouncycastle.jce.provider.JDKPKCS12KeyStore$DefPKCS12KeyStore");
        bouncyCastleProvider.put("KeyStore.PKCS12-DEF-3DES-3DES", "org.bouncycastle.jce.provider.JDKPKCS12KeyStore$DefPKCS12KeyStore3DES");
        bouncyCastleProvider.put("Alg.Alias.KeyStore.UBER", "BouncyCastle");
        bouncyCastleProvider.put("Alg.Alias.KeyStore.BOUNCYCASTLE", "BouncyCastle");
        bouncyCastleProvider.put("Alg.Alias.KeyStore.bouncycastle", "BouncyCastle");
        bouncyCastleProvider.put("CertificateFactory.X.509", "org.bouncycastle.jce.provider.JDKX509CertificateFactory");
        bouncyCastleProvider.put("Alg.Alias.CertificateFactory.X509", "X.509");
        bouncyCastleProvider.put("AlgorithmParameterGenerator.DH", "org.bouncycastle.jce.provider.JDKAlgorithmParameterGenerator$DH");
        bouncyCastleProvider.put("AlgorithmParameterGenerator.DSA", "org.bouncycastle.jce.provider.JDKAlgorithmParameterGenerator$DSA");
        bouncyCastleProvider.put("AlgorithmParameterGenerator.GOST3410", "org.bouncycastle.jce.provider.JDKAlgorithmParameterGenerator$GOST3410");
        bouncyCastleProvider.put("AlgorithmParameterGenerator.ELGAMAL", "org.bouncycastle.jce.provider.JDKAlgorithmParameterGenerator$ElGamal");
        bouncyCastleProvider.put("AlgorithmParameterGenerator.DES", "org.bouncycastle.jce.provider.JDKAlgorithmParameterGenerator$DES");
        bouncyCastleProvider.put("AlgorithmParameterGenerator.DESEDE", "org.bouncycastle.jce.provider.JDKAlgorithmParameterGenerator$DES");
        bouncyCastleProvider.put("AlgorithmParameterGenerator." + PKCSObjectIdentifiers.des_EDE3_CBC, "org.bouncycastle.jce.provider.JDKAlgorithmParameterGenerator$DES");
        bouncyCastleProvider.put("AlgorithmParameterGenerator." + OIWObjectIdentifiers.desCBC, "org.bouncycastle.jce.provider.JDKAlgorithmParameterGenerator$DES");
        bouncyCastleProvider.put("AlgorithmParameterGenerator.RC2", "org.bouncycastle.jce.provider.JDKAlgorithmParameterGenerator$RC2");
        bouncyCastleProvider.put("AlgorithmParameterGenerator.1.2.840.113549.3.2", "org.bouncycastle.jce.provider.JDKAlgorithmParameterGenerator$RC2");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameterGenerator.DIFFIEHELLMAN", "DH");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameterGenerator.GOST-3410", "GOST3410");
        bouncyCastleProvider.put("AlgorithmParameters.OAEP", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$OAEP");
        bouncyCastleProvider.put("AlgorithmParameters.PSS", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$PSS");
        bouncyCastleProvider.put("AlgorithmParameters.DH", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$DH");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.DIFFIEHELLMAN", "DH");
        bouncyCastleProvider.put("AlgorithmParameters.DSA", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$DSA");
        bouncyCastleProvider.put("AlgorithmParameters.ELGAMAL", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$ElGamal");
        bouncyCastleProvider.put("AlgorithmParameters.IES", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$IES");
        bouncyCastleProvider.put("AlgorithmParameters.PKCS12PBE", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$PKCS12PBE");
        bouncyCastleProvider.put("AlgorithmParameters." + PKCSObjectIdentifiers.des_EDE3_CBC, "org.bouncycastle.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        bouncyCastleProvider.put("AlgorithmParameters." + PKCSObjectIdentifiers.id_PBKDF2, "org.bouncycastle.jce.provider.JDKAlgorithmParameters$PBKDF2");
        bouncyCastleProvider.put("AlgorithmParameters.GOST3410", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$GOST3410");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.GOST-3410", "GOST3410");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1ANDRC2", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND3-KEYTRIPLEDES", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND2-KEYTRIPLEDES", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDRC2", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDRC4", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1ANDRC2-CBC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND3-KEYTRIPLEDES-CBC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND2-KEYTRIPLEDES-CBC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDDES3KEY-CBC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDDES2KEY-CBC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND40BITRC2-CBC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND40BITRC4", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND128BITRC2-CBC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND128BITRC4", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH-CBC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.1", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.2", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.3", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.4", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.5", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.6", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAnd3KeyTripleDES", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes128_cbc.getId(), "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes192_cbc.getId(), "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes256_cbc.getId(), "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes128_cbc.getId(), "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes192_cbc.getId(), "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes256_cbc.getId(), "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters." + PKCSObjectIdentifiers.id_RSAES_OAEP, "OAEP");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.RSAPSS", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.RSASSA-PSS", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters." + PKCSObjectIdentifiers.id_RSASSA_PSS, "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.SHA1withRSA/PSS", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.SHA224withRSA/PSS", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.SHA256withRSA/PSS", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.SHA384withRSA/PSS", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.SHA512withRSA/PSS", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.SHA1WITHRSAANDMGF1", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.SHA224WITHRSAANDMGF1", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.SHA256WITHRSAANDMGF1", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.SHA384WITHRSAANDMGF1", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.SHA512WITHRSAANDMGF1", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.RAWRSAPSS", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.NONEWITHRSAPSS", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.NONEWITHRSASSA-PSS", "PSS");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND128BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND192BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND256BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA256AND128BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA256AND192BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA256AND256BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1AND128BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1AND192BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1AND256BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-1AND128BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-1AND192BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-1AND256BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-256AND128BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-256AND192BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-256AND256BITAES-CBC-BC", "PKCS12PBE");
        bouncyCastleProvider.put("AlgorithmParameters.SHA1WITHECDSA", "org.bouncycastle.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        bouncyCastleProvider.put("AlgorithmParameters.SHA224WITHECDSA", "org.bouncycastle.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        bouncyCastleProvider.put("AlgorithmParameters.SHA256WITHECDSA", "org.bouncycastle.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        bouncyCastleProvider.put("AlgorithmParameters.SHA384WITHECDSA", "org.bouncycastle.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        bouncyCastleProvider.put("AlgorithmParameters.SHA512WITHECDSA", "org.bouncycastle.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        bouncyCastleProvider.put("KeyAgreement.DH", "org.bouncycastle.jce.provider.JCEDHKeyAgreement");
        bouncyCastleProvider.put("Alg.Alias.KeyAgreement.DIFFIEHELLMAN", "DH");
        bouncyCastleProvider.put("Cipher.DES", "org.bouncycastle.jce.provider.JCEBlockCipher$DES");
        bouncyCastleProvider.put("Cipher.DESEDE", "org.bouncycastle.jce.provider.JCEBlockCipher$DESede");
        bouncyCastleProvider.put("Cipher." + PKCSObjectIdentifiers.des_EDE3_CBC, "org.bouncycastle.jce.provider.JCEBlockCipher$DESedeCBC");
        bouncyCastleProvider.put("Cipher." + OIWObjectIdentifiers.desCBC, "org.bouncycastle.jce.provider.JCEBlockCipher$DESCBC");
        bouncyCastleProvider.put("Cipher.DESEDEWRAP", "org.bouncycastle.jce.provider.WrapCipherSpi$DESEDEWrap");
        bouncyCastleProvider.put("Cipher." + PKCSObjectIdentifiers.id_alg_CMS3DESwrap, "org.bouncycastle.jce.provider.WrapCipherSpi$DESEDEWrap");
        bouncyCastleProvider.put("Cipher.SKIPJACK", "org.bouncycastle.jce.provider.JCEBlockCipher$Skipjack");
        bouncyCastleProvider.put("Cipher.BLOWFISH", "org.bouncycastle.jce.provider.JCEBlockCipher$Blowfish");
        bouncyCastleProvider.put("Cipher.1.3.6.1.4.1.3029.1.2", "org.bouncycastle.jce.provider.JCEBlockCipher$BlowfishCBC");
        bouncyCastleProvider.put("Cipher.TWOFISH", "org.bouncycastle.jce.provider.JCEBlockCipher$Twofish");
        bouncyCastleProvider.put("Cipher.RC2", "org.bouncycastle.jce.provider.JCEBlockCipher$RC2");
        bouncyCastleProvider.put("Cipher.RC2WRAP", "org.bouncycastle.jce.provider.WrapCipherSpi$RC2Wrap");
        bouncyCastleProvider.put("Cipher.1.2.840.113549.1.9.16.3.7", "org.bouncycastle.jce.provider.WrapCipherSpi$RC2Wrap");
        bouncyCastleProvider.put("Cipher.ARC4", "org.bouncycastle.jce.provider.JCEStreamCipher$RC4");
        bouncyCastleProvider.put("Alg.Alias.Cipher.1.2.840.113549.3.4", "ARC4");
        bouncyCastleProvider.put("Alg.Alias.Cipher.ARCFOUR", "ARC4");
        bouncyCastleProvider.put("Alg.Alias.Cipher.RC4", "ARC4");
        bouncyCastleProvider.put("Cipher.SALSA20", "org.bouncycastle.jce.provider.JCEStreamCipher$Salsa20");
        bouncyCastleProvider.put("Cipher.HC128", "org.bouncycastle.jce.provider.JCEStreamCipher$HC128");
        bouncyCastleProvider.put("Cipher.HC256", "org.bouncycastle.jce.provider.JCEStreamCipher$HC256");
        bouncyCastleProvider.put("Cipher.VMPC", "org.bouncycastle.jce.provider.JCEStreamCipher$VMPC");
        bouncyCastleProvider.put("Cipher.VMPC-KSA3", "org.bouncycastle.jce.provider.JCEStreamCipher$VMPCKSA3");
        bouncyCastleProvider.put("Cipher.RC5", "org.bouncycastle.jce.provider.JCEBlockCipher$RC5");
        bouncyCastleProvider.put("Cipher.1.2.840.113549.3.2", "org.bouncycastle.jce.provider.JCEBlockCipher$RC2CBC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.RC5-32", "RC5");
        bouncyCastleProvider.put("Cipher.RC5-64", "org.bouncycastle.jce.provider.JCEBlockCipher$RC564");
        bouncyCastleProvider.put("Cipher.RC6", "org.bouncycastle.jce.provider.JCEBlockCipher$RC6");
        bouncyCastleProvider.put("Cipher.RIJNDAEL", "org.bouncycastle.jce.provider.JCEBlockCipher$Rijndael");
        bouncyCastleProvider.put("Cipher.DESEDERFC3211WRAP", "org.bouncycastle.jce.provider.WrapCipherSpi$RFC3211DESedeWrap");
        bouncyCastleProvider.put("Cipher.SERPENT", "org.bouncycastle.jce.provider.JCEBlockCipher$Serpent");
        bouncyCastleProvider.put("Cipher.CAST6", "org.bouncycastle.jce.provider.JCEBlockCipher$CAST6");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWithSHAAnd3KeyTripleDES", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        bouncyCastleProvider.put("Cipher.GOST28147", "org.bouncycastle.jce.provider.JCEBlockCipher$GOST28147");
        bouncyCastleProvider.put("Alg.Alias.Cipher.GOST", "GOST28147");
        bouncyCastleProvider.put("Alg.Alias.Cipher.GOST-28147", "GOST28147");
        bouncyCastleProvider.put("Cipher." + CryptoProObjectIdentifiers.gostR28147_cbc, "org.bouncycastle.jce.provider.JCEBlockCipher$GOST28147cbc");
        bouncyCastleProvider.put("Cipher.TEA", "org.bouncycastle.jce.provider.JCEBlockCipher$TEA");
        bouncyCastleProvider.put("Cipher.XTEA", "org.bouncycastle.jce.provider.JCEBlockCipher$XTEA");
        bouncyCastleProvider.put("Cipher.RSA", "org.bouncycastle.jce.provider.JCERSACipher$NoPadding");
        bouncyCastleProvider.put("Cipher.RSA/RAW", "org.bouncycastle.jce.provider.JCERSACipher$NoPadding");
        bouncyCastleProvider.put("Cipher.RSA/PKCS1", "org.bouncycastle.jce.provider.JCERSACipher$PKCS1v1_5Padding");
        bouncyCastleProvider.put("Cipher.1.2.840.113549.1.1.1", "org.bouncycastle.jce.provider.JCERSACipher$PKCS1v1_5Padding");
        bouncyCastleProvider.put("Cipher.2.5.8.1.1", "org.bouncycastle.jce.provider.JCERSACipher$PKCS1v1_5Padding");
        bouncyCastleProvider.put("Cipher.RSA/1", "org.bouncycastle.jce.provider.JCERSACipher$PKCS1v1_5Padding_PrivateOnly");
        bouncyCastleProvider.put("Cipher.RSA/2", "org.bouncycastle.jce.provider.JCERSACipher$PKCS1v1_5Padding_PublicOnly");
        bouncyCastleProvider.put("Cipher.RSA/OAEP", "org.bouncycastle.jce.provider.JCERSACipher$OAEPPadding");
        bouncyCastleProvider.put("Cipher." + PKCSObjectIdentifiers.id_RSAES_OAEP, "org.bouncycastle.jce.provider.JCERSACipher$OAEPPadding");
        bouncyCastleProvider.put("Cipher.RSA/ISO9796-1", "org.bouncycastle.jce.provider.JCERSACipher$ISO9796d1Padding");
        bouncyCastleProvider.put("Cipher.ECIES", "org.bouncycastle.jce.provider.JCEIESCipher$ECIES");
        bouncyCastleProvider.put("Cipher.BrokenECIES", "org.bouncycastle.jce.provider.JCEIESCipher$BrokenECIES");
        bouncyCastleProvider.put("Cipher.IES", "org.bouncycastle.jce.provider.JCEIESCipher$IES");
        bouncyCastleProvider.put("Cipher.BrokenIES", "org.bouncycastle.jce.provider.JCEIESCipher$BrokenIES");
        bouncyCastleProvider.put("Cipher.ELGAMAL", "org.bouncycastle.jce.provider.JCEElGamalCipher$NoPadding");
        bouncyCastleProvider.put("Cipher.ELGAMAL/PKCS1", "org.bouncycastle.jce.provider.JCEElGamalCipher$PKCS1v1_5Padding");
        bouncyCastleProvider.put("Alg.Alias.Cipher.RSA//RAW", "RSA");
        bouncyCastleProvider.put("Alg.Alias.Cipher.RSA//NOPADDING", "RSA");
        bouncyCastleProvider.put("Alg.Alias.Cipher.RSA//PKCS1PADDING", "RSA/PKCS1");
        bouncyCastleProvider.put("Alg.Alias.Cipher.RSA//OAEPPADDING", "RSA/OAEP");
        bouncyCastleProvider.put("Alg.Alias.Cipher.RSA//ISO9796-1PADDING", "RSA/ISO9796-1");
        bouncyCastleProvider.put("Alg.Alias.Cipher.ELGAMAL/ECB/PKCS1PADDING", "ELGAMAL/PKCS1");
        bouncyCastleProvider.put("Alg.Alias.Cipher.ELGAMAL/NONE/PKCS1PADDING", "ELGAMAL/PKCS1");
        bouncyCastleProvider.put("Alg.Alias.Cipher.ELGAMAL/NONE/NOPADDING", "ELGAMAL");
        bouncyCastleProvider.put("Cipher.PBEWITHMD5ANDDES", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithMD5AndDES");
        bouncyCastleProvider.put("Cipher.BROKENPBEWITHMD5ANDDES", "org.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithMD5AndDES");
        bouncyCastleProvider.put("Cipher.PBEWITHMD5ANDRC2", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithMD5AndRC2");
        bouncyCastleProvider.put("Cipher.PBEWITHSHA1ANDDES", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithSHA1AndDES");
        bouncyCastleProvider.put("Cipher.BROKENPBEWITHSHA1ANDDES", "org.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHA1AndDES");
        bouncyCastleProvider.put("Cipher.PBEWITHSHA1ANDRC2", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithSHA1AndRC2");
        bouncyCastleProvider.put("Cipher.PBEWITHSHAAND3-KEYTRIPLEDES-CBC", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithSHAAndDES3Key");
        bouncyCastleProvider.put("Cipher.BROKENPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "org.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHAAndDES3Key");
        bouncyCastleProvider.put("Cipher.OLDPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "org.bouncycastle.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndDES3Key");
        bouncyCastleProvider.put("Cipher.PBEWITHSHAAND2-KEYTRIPLEDES-CBC", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithSHAAndDES2Key");
        bouncyCastleProvider.put("Cipher.BROKENPBEWITHSHAAND2-KEYTRIPLEDES-CBC", "org.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHAAndDES2Key");
        bouncyCastleProvider.put("Cipher.PBEWITHSHAAND128BITRC2-CBC", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithSHAAnd128BitRC2");
        bouncyCastleProvider.put("Cipher.PBEWITHSHAAND40BITRC2-CBC", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithSHAAnd40BitRC2");
        bouncyCastleProvider.put("Cipher.PBEWITHSHAAND128BITRC4", "org.bouncycastle.jce.provider.JCEStreamCipher$PBEWithSHAAnd128BitRC4");
        bouncyCastleProvider.put("Cipher.PBEWITHSHAAND40BITRC4", "org.bouncycastle.jce.provider.JCEStreamCipher$PBEWithSHAAnd40BitRC4");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA1AND3-KEYTRIPLEDES-CBC", "Cipher.PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA1AND2-KEYTRIPLEDES-CBC", "Cipher.PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA1AND128BITRC2-CBC", "Cipher.PBEWITHSHAAND128BITRC2-CBC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA1AND40BITRC2-CBC", "Cipher.PBEWITHSHAAND40BITRC2-CBC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA1AND128BITRC4", "Cipher.PBEWITHSHAAND128BITRC4");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA1AND40BITRC4", "Cipher.PBEWITHSHAAND40BITRC4");
        bouncyCastleProvider.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes128_cbc.getId(), "PBEWITHSHAAND128BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes192_cbc.getId(), "PBEWITHSHAAND192BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes256_cbc.getId(), "PBEWITHSHAAND256BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes128_cbc.getId(), "PBEWITHSHA256AND128BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes192_cbc.getId(), "PBEWITHSHA256AND192BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes256_cbc.getId(), "PBEWITHSHA256AND256BITAES-CBC-BC");
        bouncyCastleProvider.put("Cipher.PBEWITHSHAAND128BITAES-CBC-BC", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        bouncyCastleProvider.put("Cipher.PBEWITHSHAAND192BITAES-CBC-BC", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        bouncyCastleProvider.put("Cipher.PBEWITHSHAAND256BITAES-CBC-BC", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        bouncyCastleProvider.put("Cipher.PBEWITHSHA256AND128BITAES-CBC-BC", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        bouncyCastleProvider.put("Cipher.PBEWITHSHA256AND192BITAES-CBC-BC", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        bouncyCastleProvider.put("Cipher.PBEWITHSHA256AND256BITAES-CBC-BC", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA-1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA-1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA-1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA-256AND128BITAES-CBC-BC", "PBEWITHSHA256AND128BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA-256AND192BITAES-CBC-BC", "PBEWITHSHA256AND192BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA-256AND256BITAES-CBC-BC", "PBEWITHSHA256AND256BITAES-CBC-BC");
        bouncyCastleProvider.put("Cipher.PBEWITHMD5AND128BITAES-CBC-OPENSSL", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        bouncyCastleProvider.put("Cipher.PBEWITHMD5AND192BITAES-CBC-OPENSSL", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        bouncyCastleProvider.put("Cipher.PBEWITHMD5AND256BITAES-CBC-OPENSSL", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        bouncyCastleProvider.put("Cipher.PBEWITHSHAANDTWOFISH-CBC", "org.bouncycastle.jce.provider.JCEBlockCipher$PBEWithSHAAndTwofish");
        bouncyCastleProvider.put("Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", "org.bouncycastle.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndTwofish");
        bouncyCastleProvider.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.1", "PBEWITHSHAAND128BITRC4");
        bouncyCastleProvider.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.2", "PBEWITHSHAAND40BITRC4");
        bouncyCastleProvider.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.3", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.4", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.5", "PBEWITHSHAAND128BITRC2-CBC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.6", "PBEWITHSHAAND40BITRC2-CBC");
        bouncyCastleProvider.put("Alg.Alias.Cipher.PBEWITHSHA1ANDDESEDE", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        bouncyCastleProvider.put("KeyGenerator.DES", "org.bouncycastle.jce.provider.JCEKeyGenerator$DES");
        bouncyCastleProvider.put("Alg.Alias.KeyGenerator." + OIWObjectIdentifiers.desCBC, "DES");
        bouncyCastleProvider.put("KeyGenerator.DESEDE", "org.bouncycastle.jce.provider.JCEKeyGenerator$DESede");
        bouncyCastleProvider.put("KeyGenerator." + PKCSObjectIdentifiers.des_EDE3_CBC, "org.bouncycastle.jce.provider.JCEKeyGenerator$DESede3");
        bouncyCastleProvider.put("KeyGenerator.DESEDEWRAP", "org.bouncycastle.jce.provider.JCEKeyGenerator$DESede");
        bouncyCastleProvider.put("KeyGenerator.SKIPJACK", "org.bouncycastle.jce.provider.JCEKeyGenerator$Skipjack");
        bouncyCastleProvider.put("KeyGenerator.BLOWFISH", "org.bouncycastle.jce.provider.JCEKeyGenerator$Blowfish");
        bouncyCastleProvider.put("Alg.Alias.KeyGenerator.1.3.6.1.4.1.3029.1.2", "BLOWFISH");
        bouncyCastleProvider.put("KeyGenerator.TWOFISH", "org.bouncycastle.jce.provider.JCEKeyGenerator$Twofish");
        bouncyCastleProvider.put("KeyGenerator.RC2", "org.bouncycastle.jce.provider.JCEKeyGenerator$RC2");
        bouncyCastleProvider.put("KeyGenerator.1.2.840.113549.3.2", "org.bouncycastle.jce.provider.JCEKeyGenerator$RC2");
        bouncyCastleProvider.put("KeyGenerator.RC4", "org.bouncycastle.jce.provider.JCEKeyGenerator$RC4");
        bouncyCastleProvider.put("Alg.Alias.KeyGenerator.ARC4", "RC4");
        bouncyCastleProvider.put("Alg.Alias.KeyGenerator.1.2.840.113549.3.4", "RC4");
        bouncyCastleProvider.put("KeyGenerator.RC5", "org.bouncycastle.jce.provider.JCEKeyGenerator$RC5");
        bouncyCastleProvider.put("Alg.Alias.KeyGenerator.RC5-32", "RC5");
        bouncyCastleProvider.put("KeyGenerator.RC5-64", "org.bouncycastle.jce.provider.JCEKeyGenerator$RC564");
        bouncyCastleProvider.put("KeyGenerator.RC6", "org.bouncycastle.jce.provider.JCEKeyGenerator$RC6");
        bouncyCastleProvider.put("KeyGenerator.RIJNDAEL", "org.bouncycastle.jce.provider.JCEKeyGenerator$Rijndael");
        bouncyCastleProvider.put("KeyGenerator.SERPENT", "org.bouncycastle.jce.provider.JCEKeyGenerator$Serpent");
        bouncyCastleProvider.put("KeyGenerator.SALSA20", "org.bouncycastle.jce.provider.JCEKeyGenerator$Salsa20");
        bouncyCastleProvider.put("KeyGenerator.HC128", "org.bouncycastle.jce.provider.JCEKeyGenerator$HC128");
        bouncyCastleProvider.put("KeyGenerator.HC256", "org.bouncycastle.jce.provider.JCEKeyGenerator$HC256");
        bouncyCastleProvider.put("KeyGenerator.VMPC", "org.bouncycastle.jce.provider.JCEKeyGenerator$VMPC");
        bouncyCastleProvider.put("KeyGenerator.VMPC-KSA3", "org.bouncycastle.jce.provider.JCEKeyGenerator$VMPCKSA3");
        bouncyCastleProvider.put("KeyGenerator.CAST6", "org.bouncycastle.jce.provider.JCEKeyGenerator$CAST6");
        bouncyCastleProvider.put("KeyGenerator.TEA", "org.bouncycastle.jce.provider.JCEKeyGenerator$TEA");
        bouncyCastleProvider.put("KeyGenerator.XTEA", "org.bouncycastle.jce.provider.JCEKeyGenerator$XTEA");
        bouncyCastleProvider.put("KeyGenerator.GOST28147", "org.bouncycastle.jce.provider.JCEKeyGenerator$GOST28147");
        bouncyCastleProvider.put("Alg.Alias.KeyGenerator.GOST", "GOST28147");
        bouncyCastleProvider.put("Alg.Alias.KeyGenerator.GOST-28147", "GOST28147");
        bouncyCastleProvider.put("Alg.Alias.KeyGenerator." + CryptoProObjectIdentifiers.gostR28147_cbc, "GOST28147");
        bouncyCastleProvider.put("KeyPairGenerator.RSA", "org.bouncycastle.jce.provider.JDKKeyPairGenerator$RSA");
        bouncyCastleProvider.put("KeyPairGenerator.DH", "org.bouncycastle.jce.provider.JDKKeyPairGenerator$DH");
        bouncyCastleProvider.put("KeyPairGenerator.DSA", "org.bouncycastle.jce.provider.JDKKeyPairGenerator$DSA");
        bouncyCastleProvider.put("KeyPairGenerator.ELGAMAL", "org.bouncycastle.jce.provider.JDKKeyPairGenerator$ElGamal");
        bouncyCastleProvider.put("Alg.Alias.KeyPairGenerator.1.2.840.113549.1.1.1", "RSA");
        bouncyCastleProvider.put("Alg.Alias.KeyPairGenerator.DIFFIEHELLMAN", "DH");
        bouncyCastleProvider.put("KeyPairGenerator.GOST3410", "org.bouncycastle.jce.provider.JDKKeyPairGenerator$GOST3410");
        bouncyCastleProvider.put("Alg.Alias.KeyPairGenerator.GOST-3410", "GOST3410");
        bouncyCastleProvider.put("Alg.Alias.KeyPairGenerator.GOST-3410-94", "GOST3410");
        bouncyCastleProvider.put("KeyFactory.RSA", "org.bouncycastle.jce.provider.JDKKeyFactory$RSA");
        bouncyCastleProvider.put("KeyFactory.DH", "org.bouncycastle.jce.provider.JDKKeyFactory$DH");
        bouncyCastleProvider.put("KeyFactory.DSA", "org.bouncycastle.jce.provider.JDKKeyFactory$DSA");
        bouncyCastleProvider.put("KeyFactory.ELGAMAL", "org.bouncycastle.jce.provider.JDKKeyFactory$ElGamal");
        bouncyCastleProvider.put("KeyFactory.ElGamal", "org.bouncycastle.jce.provider.JDKKeyFactory$ElGamal");
        bouncyCastleProvider.put("KeyFactory.X.509", "org.bouncycastle.jce.provider.JDKKeyFactory$X509");
        bouncyCastleProvider.put("Alg.Alias.KeyFactory.1.2.840.113549.1.1.1", "RSA");
        bouncyCastleProvider.put("Alg.Alias.KeyFactory.1.2.840.10040.4.1", "DSA");
        bouncyCastleProvider.put("Alg.Alias.KeyFactory.DIFFIEHELLMAN", "DH");
        bouncyCastleProvider.put("KeyFactory.GOST3410", "org.bouncycastle.jce.provider.JDKKeyFactory$GOST3410");
        bouncyCastleProvider.put("Alg.Alias.KeyFactory.GOST-3410", "GOST3410");
        bouncyCastleProvider.put("Alg.Alias.KeyFactory.GOST-3410-94", "GOST3410");
        bouncyCastleProvider.put("Alg.Alias.KeyFactory." + CryptoProObjectIdentifiers.gostR3410_94, "GOST3410");
        bouncyCastleProvider.put("AlgorithmParameters.DES", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters." + OIWObjectIdentifiers.desCBC, "DES");
        bouncyCastleProvider.put("AlgorithmParameters.DESEDE", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        bouncyCastleProvider.put("AlgorithmParameters." + PKCSObjectIdentifiers.des_EDE3_CBC, "org.bouncycastle.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        bouncyCastleProvider.put("AlgorithmParameters.RC2", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$RC2AlgorithmParameters");
        bouncyCastleProvider.put("AlgorithmParameters.1.2.840.113549.3.2", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$RC2AlgorithmParameters");
        bouncyCastleProvider.put("AlgorithmParameters.RC5", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        bouncyCastleProvider.put("AlgorithmParameters.RC6", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        bouncyCastleProvider.put("AlgorithmParameters.BLOWFISH", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        bouncyCastleProvider.put("Alg.Alias.AlgorithmParameters.1.3.6.1.4.1.3029.1.2", "BLOWFISH");
        bouncyCastleProvider.put("AlgorithmParameters.TWOFISH", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        bouncyCastleProvider.put("AlgorithmParameters.SKIPJACK", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        bouncyCastleProvider.put("AlgorithmParameters.RIJNDAEL", "org.bouncycastle.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        bouncyCastleProvider.put("SecretKeyFactory.DES", "org.bouncycastle.jce.provider.JCESecretKeyFactory$DES");
        bouncyCastleProvider.put("SecretKeyFactory.DESEDE", "org.bouncycastle.jce.provider.JCESecretKeyFactory$DESede");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHMD2ANDDES", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithMD2AndDES");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHMD2ANDRC2", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithMD2AndRC2");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHMD5ANDDES", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithMD5AndDES");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHMD5ANDRC2", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithMD5AndRC2");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHA1ANDDES", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHA1AndDES");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHA1ANDRC2", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHA1AndRC2");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHAAND3-KEYTRIPLEDES-CBC", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHAAndDES3Key");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHAAND2-KEYTRIPLEDES-CBC", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHAAndDES2Key");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHAAND128BITRC4", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd128BitRC4");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHAAND40BITRC4", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd40BitRC4");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHAAND128BITRC2-CBC", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd128BitRC2");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHAAND40BITRC2-CBC", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd40BitRC2");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHAANDTWOFISH-CBC", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHAAndTwofish");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHHMACRIPEMD160", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithRIPEMD160");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHHMACSHA1", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHA");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHHMACTIGER", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithTiger");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHMD5AND128BITAES-CBC-OPENSSL", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithMD5And128BitAESCBCOpenSSL");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHMD5AND192BITAES-CBC-OPENSSL", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithMD5And192BitAESCBCOpenSSL");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHMD5AND256BITAES-CBC-OPENSSL", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithMD5And256BitAESCBCOpenSSL");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBE", "PBE/PKCS5");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHMD5ANDDES", "PBE/PKCS5");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHSHA1ANDDES", "PBE/PKCS5");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.OLDPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "PBE/PKCS12");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "PBE/PKCS12");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHSHAAND2-KEYTRIPLEDES-CBC", "PBE/PKCS12");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.OLDPBEWITHSHAANDTWOFISH-CBC", "PBE/PKCS12");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHMD2ANDDES-CBC", "PBEWITHMD2ANDDES");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHMD2ANDRC2-CBC", "PBEWITHMD2ANDRC2");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHMD5ANDDES-CBC", "PBEWITHMD5ANDDES");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHMD5ANDRC2-CBC", "PBEWITHMD5ANDRC2");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1ANDDES-CBC", "PBEWITHSHA1ANDDES");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1ANDRC2-CBC", "PBEWITHSHA1ANDRC2");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC, "PBEWITHMD2ANDDES");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC, "PBEWITHMD2ANDRC2");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC, "PBEWITHMD5ANDDES");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC, "PBEWITHMD5ANDRC2");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC, "PBEWITHSHA1ANDDES");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC, "PBEWITHSHA1ANDRC2");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.1", "PBEWITHSHAAND128BITRC4");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.2", "PBEWITHSHAAND40BITRC4");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.3", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.4", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.5", "PBEWITHSHAAND128BITRC2-CBC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.6", "PBEWITHSHAAND40BITRC2-CBC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHHMACSHA", "PBEWITHHMACSHA1");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.1.3.14.3.2.26", "PBEWITHHMACSHA1");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWithSHAAnd3KeyTripleDES", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHAAND128BITAES-CBC-BC", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd128BitAESBC");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHAAND192BITAES-CBC-BC", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd192BitAESBC");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHAAND256BITAES-CBC-BC", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd256BitAESBC");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHA256AND128BITAES-CBC-BC", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHA256And128BitAESBC");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHA256AND192BITAES-CBC-BC", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHA256And192BitAESBC");
        bouncyCastleProvider.put("SecretKeyFactory.PBEWITHSHA256AND256BITAES-CBC-BC", "org.bouncycastle.jce.provider.JCESecretKeyFactory$PBEWithSHA256And256BitAESBC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-256AND128BITAES-CBC-BC", "PBEWITHSHA256AND128BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-256AND192BITAES-CBC-BC", "PBEWITHSHA256AND192BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-256AND256BITAES-CBC-BC", "PBEWITHSHA256AND256BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes128_cbc.getId(), "PBEWITHSHAAND128BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes192_cbc.getId(), "PBEWITHSHAAND192BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes256_cbc.getId(), "PBEWITHSHAAND256BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes128_cbc.getId(), "PBEWITHSHA256AND128BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes192_cbc.getId(), "PBEWITHSHA256AND192BITAES-CBC-BC");
        bouncyCastleProvider.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes256_cbc.getId(), "PBEWITHSHA256AND256BITAES-CBC-BC");
        BouncyCastleProvider bouncyCastleProvider2 = bouncyCastleProvider;
        bouncyCastleProvider2.put("Mac.DESMAC", "org.bouncycastle.jce.provider.JCEMac$DES");
        bouncyCastleProvider2.put("Alg.Alias.Mac.DES", "DESMAC");
        bouncyCastleProvider2.put("Mac.DESMAC/CFB8", "org.bouncycastle.jce.provider.JCEMac$DESCFB8");
        bouncyCastleProvider2.put("Alg.Alias.Mac.DES/CFB8", "DESMAC/CFB8");
        bouncyCastleProvider2.put("Mac.DESEDEMAC", "org.bouncycastle.jce.provider.JCEMac$DESede");
        bouncyCastleProvider2.put("Alg.Alias.Mac.DESEDE", "DESEDEMAC");
        bouncyCastleProvider2.put("Mac.DESEDEMAC/CFB8", "org.bouncycastle.jce.provider.JCEMac$DESedeCFB8");
        bouncyCastleProvider2.put("Alg.Alias.Mac.DESEDE/CFB8", "DESEDEMAC/CFB8");
        bouncyCastleProvider2.put("Mac.DESWITHISO9797", "org.bouncycastle.jce.provider.JCEMac$DES9797Alg3");
        bouncyCastleProvider2.put("Alg.Alias.Mac.DESISO9797MAC", "DESWITHISO9797");
        bouncyCastleProvider2.put("Mac.DESEDEMAC64", "org.bouncycastle.jce.provider.JCEMac$DESede64");
        bouncyCastleProvider2.put("Alg.Alias.Mac.DESEDE64", "DESEDEMAC64");
        bouncyCastleProvider2.put("Mac.DESEDEMAC64WITHISO7816-4PADDING", "org.bouncycastle.jce.provider.JCEMac$DESede64with7816d4");
        bouncyCastleProvider2.put("Alg.Alias.Mac.DESEDE64WITHISO7816-4PADDING", "DESEDEMAC64WITHISO7816-4PADDING");
        bouncyCastleProvider2.put("Alg.Alias.Mac.DESEDEISO9797ALG1MACWITHISO7816-4PADDING", "DESEDEMAC64WITHISO7816-4PADDING");
        bouncyCastleProvider2.put("Alg.Alias.Mac.DESEDEISO9797ALG1WITHISO7816-4PADDING", "DESEDEMAC64WITHISO7816-4PADDING");
        bouncyCastleProvider2.put("Mac.ISO9797ALG3MAC", "org.bouncycastle.jce.provider.JCEMac$DES9797Alg3");
        bouncyCastleProvider2.put("Alg.Alias.Mac.ISO9797ALG3", "ISO9797ALG3MAC");
        bouncyCastleProvider2.put("Mac.ISO9797ALG3WITHISO7816-4PADDING", "org.bouncycastle.jce.provider.JCEMac$DES9797Alg3with7816d4");
        bouncyCastleProvider2.put("Alg.Alias.Mac.ISO9797ALG3MACWITHISO7816-4PADDING", "ISO9797ALG3WITHISO7816-4PADDING");
        bouncyCastleProvider2.put("Mac.SKIPJACKMAC", "org.bouncycastle.jce.provider.JCEMac$Skipjack");
        bouncyCastleProvider2.put("Alg.Alias.Mac.SKIPJACK", "SKIPJACKMAC");
        bouncyCastleProvider2.put("Mac.SKIPJACKMAC/CFB8", "org.bouncycastle.jce.provider.JCEMac$SkipjackCFB8");
        bouncyCastleProvider2.put("Alg.Alias.Mac.SKIPJACK/CFB8", "SKIPJACKMAC/CFB8");
        bouncyCastleProvider2.put("Mac.RC2MAC", "org.bouncycastle.jce.provider.JCEMac$RC2");
        bouncyCastleProvider2.put("Alg.Alias.Mac.RC2", "RC2MAC");
        bouncyCastleProvider2.put("Mac.RC2MAC/CFB8", "org.bouncycastle.jce.provider.JCEMac$RC2CFB8");
        bouncyCastleProvider2.put("Alg.Alias.Mac.RC2/CFB8", "RC2MAC/CFB8");
        bouncyCastleProvider2.put("Mac.RC5MAC", "org.bouncycastle.jce.provider.JCEMac$RC5");
        bouncyCastleProvider2.put("Alg.Alias.Mac.RC5", "RC5MAC");
        bouncyCastleProvider2.put("Mac.RC5MAC/CFB8", "org.bouncycastle.jce.provider.JCEMac$RC5CFB8");
        bouncyCastleProvider2.put("Alg.Alias.Mac.RC5/CFB8", "RC5MAC/CFB8");
        bouncyCastleProvider2.put("Mac.GOST28147MAC", "org.bouncycastle.jce.provider.JCEMac$GOST28147");
        bouncyCastleProvider2.put("Alg.Alias.Mac.GOST28147", "GOST28147MAC");
        bouncyCastleProvider2.put("Mac.VMPCMAC", "org.bouncycastle.jce.provider.JCEMac$VMPC");
        bouncyCastleProvider2.put("Alg.Alias.Mac.VMPC", "VMPCMAC");
        bouncyCastleProvider2.put("Alg.Alias.Mac.VMPC-MAC", "VMPCMAC");
        bouncyCastleProvider2.put("Mac.OLDHMACSHA384", "org.bouncycastle.jce.provider.JCEMac$OldSHA384");
        bouncyCastleProvider2.put("Mac.OLDHMACSHA512", "org.bouncycastle.jce.provider.JCEMac$OldSHA512");
        bouncyCastleProvider2.addHMACAlgorithm("MD2", "org.bouncycastle.jce.provider.JCEMac$MD2", "org.bouncycastle.jce.provider.JCEKeyGenerator$MD2HMAC");
        bouncyCastleProvider2.addHMACAlgorithm("MD4", "org.bouncycastle.jce.provider.JCEMac$MD4", "org.bouncycastle.jce.provider.JCEKeyGenerator$MD4HMAC");
        bouncyCastleProvider2.addHMACAlgorithm("MD5", "org.bouncycastle.jce.provider.JCEMac$MD5", "org.bouncycastle.jce.provider.JCEKeyGenerator$MD5HMAC");
        bouncyCastleProvider2.addHMACAlias("MD5", IANAObjectIdentifiers.hmacMD5);
        bouncyCastleProvider2.addHMACAlgorithm("SHA1", "org.bouncycastle.jce.provider.JCEMac$SHA1", "org.bouncycastle.jce.provider.JCEKeyGenerator$HMACSHA1");
        bouncyCastleProvider2.addHMACAlias("SHA1", PKCSObjectIdentifiers.id_hmacWithSHA1);
        bouncyCastleProvider2.addHMACAlias("SHA1", IANAObjectIdentifiers.hmacSHA1);
        bouncyCastleProvider2.addHMACAlgorithm("SHA224", "org.bouncycastle.jce.provider.JCEMac$SHA224", "org.bouncycastle.jce.provider.JCEKeyGenerator$HMACSHA224");
        bouncyCastleProvider2.addHMACAlias("SHA224", PKCSObjectIdentifiers.id_hmacWithSHA224);
        bouncyCastleProvider2.addHMACAlgorithm("SHA256", "org.bouncycastle.jce.provider.JCEMac$SHA256", "org.bouncycastle.jce.provider.JCEKeyGenerator$HMACSHA256");
        bouncyCastleProvider2.addHMACAlias("SHA256", PKCSObjectIdentifiers.id_hmacWithSHA256);
        bouncyCastleProvider2.addHMACAlgorithm("SHA384", "org.bouncycastle.jce.provider.JCEMac$SHA384", "org.bouncycastle.jce.provider.JCEKeyGenerator$HMACSHA384");
        bouncyCastleProvider2.addHMACAlias("SHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        bouncyCastleProvider2.addHMACAlgorithm("SHA512", "org.bouncycastle.jce.provider.JCEMac$SHA512", "org.bouncycastle.jce.provider.JCEKeyGenerator$HMACSHA512");
        bouncyCastleProvider2.addHMACAlias("SHA512", PKCSObjectIdentifiers.id_hmacWithSHA512);
        bouncyCastleProvider2.addHMACAlgorithm("RIPEMD128", "org.bouncycastle.jce.provider.JCEMac$RIPEMD128", "org.bouncycastle.jce.provider.JCEKeyGenerator$RIPEMD128HMAC");
        bouncyCastleProvider2.addHMACAlgorithm("RIPEMD160", "org.bouncycastle.jce.provider.JCEMac$RIPEMD160", "org.bouncycastle.jce.provider.JCEKeyGenerator$RIPEMD160HMAC");
        bouncyCastleProvider2.addHMACAlias("RIPEMD160", IANAObjectIdentifiers.hmacRIPEMD160);
        bouncyCastleProvider2.addHMACAlgorithm("TIGER", "org.bouncycastle.jce.provider.JCEMac$Tiger", "org.bouncycastle.jce.provider.JCEKeyGenerator$HMACTIGER");
        bouncyCastleProvider2.addHMACAlias("TIGER", IANAObjectIdentifiers.hmacTIGER);
        bouncyCastleProvider2.put("Mac.PBEWITHHMACSHA", "org.bouncycastle.jce.provider.JCEMac$PBEWithSHA");
        bouncyCastleProvider2.put("Mac.PBEWITHHMACSHA1", "org.bouncycastle.jce.provider.JCEMac$PBEWithSHA");
        bouncyCastleProvider2.put("Mac.PBEWITHHMACRIPEMD160", "org.bouncycastle.jce.provider.JCEMac$PBEWithRIPEMD160");
        bouncyCastleProvider2.put("Alg.Alias.Mac.1.3.14.3.2.26", "PBEWITHHMACSHA");
        bouncyCastleProvider2 = bouncyCastleProvider;
        bouncyCastleProvider2.put("MessageDigest.SHA-1", "org.bouncycastle.jce.provider.JDKMessageDigest$SHA1");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest.SHA1", "SHA-1");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest.SHA", "SHA-1");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest." + OIWObjectIdentifiers.idSHA1, "SHA-1");
        bouncyCastleProvider2.put("MessageDigest.SHA-224", "org.bouncycastle.jce.provider.JDKMessageDigest$SHA224");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest.SHA224", "SHA-224");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha224, "SHA-224");
        bouncyCastleProvider2.put("MessageDigest.SHA-256", "org.bouncycastle.jce.provider.JDKMessageDigest$SHA256");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest.SHA256", "SHA-256");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha256, "SHA-256");
        bouncyCastleProvider2.put("MessageDigest.SHA-384", "org.bouncycastle.jce.provider.JDKMessageDigest$SHA384");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest.SHA384", "SHA-384");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha384, "SHA-384");
        bouncyCastleProvider2.put("MessageDigest.SHA-512", "org.bouncycastle.jce.provider.JDKMessageDigest$SHA512");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest.SHA512", "SHA-512");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha512, "SHA-512");
        bouncyCastleProvider2.put("MessageDigest.MD2", "org.bouncycastle.jce.provider.JDKMessageDigest$MD2");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md2, "MD2");
        bouncyCastleProvider2.put("MessageDigest.MD4", "org.bouncycastle.jce.provider.JDKMessageDigest$MD4");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md4, "MD4");
        bouncyCastleProvider2.put("MessageDigest.MD5", "org.bouncycastle.jce.provider.JDKMessageDigest$MD5");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md5, "MD5");
        bouncyCastleProvider2.put("MessageDigest.RIPEMD128", "org.bouncycastle.jce.provider.JDKMessageDigest$RIPEMD128");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd128, "RIPEMD128");
        bouncyCastleProvider2.put("MessageDigest.RIPEMD160", "org.bouncycastle.jce.provider.JDKMessageDigest$RIPEMD160");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd160, "RIPEMD160");
        bouncyCastleProvider2.put("MessageDigest.RIPEMD256", "org.bouncycastle.jce.provider.JDKMessageDigest$RIPEMD256");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd256, "RIPEMD256");
        bouncyCastleProvider2.put("MessageDigest.RIPEMD320", "org.bouncycastle.jce.provider.JDKMessageDigest$RIPEMD320");
        bouncyCastleProvider2.put("MessageDigest.Tiger", "org.bouncycastle.jce.provider.JDKMessageDigest$Tiger");
        bouncyCastleProvider2.put("MessageDigest.WHIRLPOOL", "org.bouncycastle.jce.provider.JDKMessageDigest$Whirlpool");
        bouncyCastleProvider2.put("MessageDigest.GOST3411", "org.bouncycastle.jce.provider.JDKMessageDigest$GOST3411");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest.GOST", "GOST3411");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest.GOST-3411", "GOST3411");
        bouncyCastleProvider2.put("Alg.Alias.MessageDigest." + CryptoProObjectIdentifiers.gostR3411, "GOST3411");
        bouncyCastleProvider.addSignatureAlgorithms();
        bouncyCastleProvider.put("CertPathValidator.RFC3281", "org.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
        bouncyCastleProvider.put("CertPathBuilder.RFC3281", "org.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
        bouncyCastleProvider.put("CertPathValidator.RFC3280", "org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
        bouncyCastleProvider.put("CertPathBuilder.RFC3280", "org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
        bouncyCastleProvider.put("CertPathValidator.PKIX", "org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
        bouncyCastleProvider.put("CertPathBuilder.PKIX", "org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
        bouncyCastleProvider.put("CertStore.Collection", "org.bouncycastle.jce.provider.CertStoreCollectionSpi");
        bouncyCastleProvider.put("CertStore.LDAP", "org.bouncycastle.jce.provider.X509LDAPCertStoreSpi");
        bouncyCastleProvider.put("CertStore.Multi", "org.bouncycastle.jce.provider.MultiCertStoreSpi");
        bouncyCastleProvider.put("Alg.Alias.CertStore.X509LDAP", "LDAP");
    }
}

