/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.math.BigInteger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

final class RSACoreEngine {
    private RSAKeyParameters key;
    private boolean forEncryption;

    RSACoreEngine() {
    }

    public final void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = (ParametersWithRandom)cipherParameters;
            this.key = null;
        } else {
            this.key = (RSAKeyParameters)cipherParameters;
        }
        this.forEncryption = bl;
    }

    public final int getInputBlockSize() {
        int n = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (n + 7) / 8 - 1;
        }
        return (n + 7) / 8;
    }

    public final int getOutputBlockSize() {
        int n = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (n + 7) / 8;
        }
        return (n + 7) / 8 - 1;
    }

    public final BigInteger convertInput(byte[] object, int n, int n2) {
        byte[] byArray;
        if (n2 > this.getInputBlockSize() + 1) {
            throw new DataLengthException("input too large for RSA cipher.");
        }
        if (n2 == this.getInputBlockSize() + 1 && !this.forEncryption) {
            throw new DataLengthException("input too large for RSA cipher.");
        }
        if (n != 0 || n2 != ((byte[])object).length) {
            byArray = new byte[n2];
            System.arraycopy(object, n, byArray, 0, n2);
        } else {
            byArray = object;
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        object = bigInteger;
        if (bigInteger.compareTo(this.key.getModulus()) >= 0) {
            throw new DataLengthException("input too large for RSA cipher.");
        }
        return object;
    }

    public final byte[] convertOutput(BigInteger object) {
        object = ((BigInteger)object).toByteArray();
        if (this.forEncryption) {
            if (object[0] == false && ((Object)object).length > this.getOutputBlockSize()) {
                byte[] byArray = new byte[((Object)object).length - 1];
                System.arraycopy(object, 1, byArray, 0, byArray.length);
                return byArray;
            }
            if (((Object)object).length < this.getOutputBlockSize()) {
                byte[] byArray = new byte[this.getOutputBlockSize()];
                System.arraycopy(object, 0, byArray, byArray.length - ((Object)object).length, ((Object)object).length);
                return byArray;
            }
        } else if (object[0] == false) {
            byte[] byArray = new byte[((Object)object).length - 1];
            System.arraycopy(object, 1, byArray, 0, byArray.length);
            return byArray;
        }
        return object;
    }

    public final BigInteger processBlock(BigInteger bigInteger) {
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            Object object = (RSAPrivateCrtKeyParameters)this.key;
            BigInteger bigInteger2 = ((RSAPrivateCrtKeyParameters)object).getP();
            BigInteger bigInteger3 = ((RSAPrivateCrtKeyParameters)object).getQ();
            BigInteger bigInteger4 = ((RSAPrivateCrtKeyParameters)object).getDP();
            BigInteger bigInteger5 = ((RSAPrivateCrtKeyParameters)object).getDQ();
            object = ((RSAPrivateCrtKeyParameters)object).getQInv();
            bigInteger4 = bigInteger.remainder(bigInteger2).modPow(bigInteger4, bigInteger2);
            bigInteger = bigInteger.remainder(bigInteger3).modPow(bigInteger5, bigInteger3);
            bigInteger4 = bigInteger4.subtract(bigInteger);
            bigInteger4 = bigInteger4.multiply((BigInteger)object);
            bigInteger4 = bigInteger4.mod(bigInteger2);
            object = bigInteger4.multiply(bigInteger3);
            object = ((BigInteger)object).add(bigInteger);
            return object;
        }
        return bigInteger.modPow(this.key.getExponent(), this.key.getModulus());
    }
}

