/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.LazyDERConstructionEnumeration;

public final class LazyDERSequence
extends DERSequence {
    private byte[] encoded;
    private boolean parsed = false;
    private int size = -1;

    LazyDERSequence(byte[] byArray) throws IOException {
        this.encoded = byArray;
    }

    @Override
    public final DEREncodable getObjectAt(int n) {
        if (!this.parsed) {
            LazyDERSequence lazyDERSequence = this;
            LazyDERConstructionEnumeration lazyDERConstructionEnumeration = new LazyDERConstructionEnumeration(lazyDERSequence.encoded);
            while (lazyDERConstructionEnumeration.hasMoreElements()) {
                lazyDERSequence.addObject((DEREncodable)lazyDERConstructionEnumeration.nextElement());
            }
            lazyDERSequence.parsed = true;
        }
        return super.getObjectAt(n);
    }

    @Override
    public final Enumeration getObjects() {
        if (this.parsed) {
            return super.getObjects();
        }
        return new LazyDERConstructionEnumeration(this.encoded);
    }

    @Override
    public final int size() {
        if (this.size < 0) {
            LazyDERConstructionEnumeration lazyDERConstructionEnumeration = new LazyDERConstructionEnumeration(this.encoded);
            this.size = 0;
            while (lazyDERConstructionEnumeration.hasMoreElements()) {
                lazyDERConstructionEnumeration.nextElement();
                ++this.size;
            }
        }
        return this.size;
    }

    @Override
    final void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(48, this.encoded);
    }
}

