/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

public abstract class ASN1Set
extends ASN1Object {
    private Vector set = new Vector();

    public final Enumeration getObjects() {
        return this.set.elements();
    }

    public final DEREncodable getObjectAt(int n) {
        return (DEREncodable)this.set.elementAt(n);
    }

    public final int size() {
        return this.set.size();
    }

    @Override
    public int hashCode() {
        ASN1Set aSN1Set = this;
        Enumeration enumeration = aSN1Set.set.elements();
        aSN1Set = this;
        int n = aSN1Set.set.size();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            n *= 17;
            if (e == null) continue;
            n ^= e.hashCode();
        }
        return n;
    }

    @Override
    final boolean asn1Equals(DERObject object) {
        if (!(object instanceof ASN1Set)) {
            return false;
        }
        object = (ASN1Set)object;
        ASN1Set aSN1Set = this;
        DERObject dERObject = aSN1Set;
        dERObject = object;
        if (aSN1Set.set.size() != ((ASN1Set)dERObject).set.size()) {
            return false;
        }
        dERObject = this;
        Enumeration enumeration = ((ASN1Set)dERObject).set.elements();
        dERObject = object;
        object = ((ASN1Set)dERObject).set.elements();
        while (enumeration.hasMoreElements()) {
            DERObject dERObject2;
            dERObject = ((DEREncodable)enumeration.nextElement()).getDERObject();
            if (dERObject == (dERObject2 = ((DEREncodable)object.nextElement()).getDERObject()) || dERObject != null && dERObject.equals(dERObject2)) continue;
            return false;
        }
        return true;
    }

    private static byte[] getEncoded(DEREncodable dEREncodable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        try {
            aSN1OutputStream.writeObject(dEREncodable);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected final void sort() {
        if (this.set.size() > 1) {
            boolean bl = true;
            int n = this.set.size() - 1;
            while (bl) {
                int n2 = 0;
                byte[] byArray = ASN1Set.getEncoded((DEREncodable)this.set.elementAt(0));
                bl = false;
                for (int i = 0; i != n; ++i) {
                    boolean bl2;
                    byte[] byArray2;
                    block11: {
                        int n3;
                        int n4;
                        int n5;
                        byte[] byArray3 = byArray2 = ASN1Set.getEncoded((DEREncodable)this.set.elementAt(i + 1));
                        byte[] byArray4 = byArray;
                        if (byArray.length <= byArray3.length) {
                            for (n5 = 0; n5 != byArray4.length; ++n5) {
                                n4 = byArray3[n5] & 0xFF;
                                n3 = byArray4[n5] & 0xFF;
                                if (n4 > n3) {
                                    bl2 = true;
                                    break block11;
                                }
                                if (n3 <= n4) {
                                    continue;
                                }
                                break block12;
                            }
                            bl2 = true;
                        } else {
                            block12: {
                                for (n5 = 0; n5 != byArray3.length; ++n5) {
                                    n4 = byArray3[n5] & 0xFF;
                                    n3 = byArray4[n5] & 0xFF;
                                    if (n4 > n3) {
                                        bl2 = true;
                                        break block11;
                                    }
                                    if (n3 > n4) break;
                                }
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        byArray = byArray2;
                        continue;
                    }
                    Object e = this.set.elementAt(i);
                    this.set.setElementAt(this.set.elementAt(i + 1), i);
                    this.set.setElementAt(e, i + 1);
                    bl = true;
                    n2 = i;
                }
                n = n2;
            }
        }
    }

    protected void addObject(DEREncodable dEREncodable) {
        this.set.addElement(dEREncodable);
    }

    public String toString() {
        return this.set.toString();
    }
}

