/*
 * Decompiled with CFR 0.152.
 */
package ch.elca.el4j.services.xmlmerge.merge;

import ch.elca.el4j.services.xmlmerge.AbstractXmlMergeException;
import ch.elca.el4j.services.xmlmerge.DocumentException;
import ch.elca.el4j.services.xmlmerge.Mapper;
import ch.elca.el4j.services.xmlmerge.Matcher;
import ch.elca.el4j.services.xmlmerge.MergeAction;
import ch.elca.el4j.services.xmlmerge.ParseException;
import ch.elca.el4j.services.xmlmerge.XmlMerge;
import ch.elca.el4j.services.xmlmerge.action.OrderedMergeAction;
import ch.elca.el4j.services.xmlmerge.factory.StaticOperationFactory;
import ch.elca.el4j.services.xmlmerge.mapper.IdentityMapper;
import ch.elca.el4j.services.xmlmerge.matcher.TagMatcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class DefaultXmlMerge
implements XmlMerge {
    private Mapper m_rootMapper = new IdentityMapper();
    private MergeAction m_rootMergeAction = new OrderedMergeAction();
    private Matcher m_rootMatcher = new TagMatcher();

    public DefaultXmlMerge() {
        this.m_rootMergeAction.setActionFactory(new StaticOperationFactory(new OrderedMergeAction()));
        this.m_rootMergeAction.setMapperFactory(new StaticOperationFactory(new IdentityMapper()));
        this.m_rootMergeAction.setMatcherFactory(new StaticOperationFactory(new TagMatcher()));
    }

    public void setRootMapper(Mapper rootMapper) {
        this.m_rootMapper = rootMapper;
    }

    public void setRootMergeAction(MergeAction rootMergeAction) {
        this.m_rootMergeAction = rootMergeAction;
    }

    public String merge(String[] sources) throws AbstractXmlMergeException {
        InputStream[] inputStreams = new InputStream[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            inputStreams[i] = new ByteArrayInputStream(sources[i].getBytes());
        }
        InputStream merged = this.merge(inputStreams);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = merged.read(buffer)) != -1) {
                result.write(buffer, 0, len);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return result.toString();
    }

    public org.w3c.dom.Document merge(org.w3c.dom.Document[] sources) throws AbstractXmlMergeException {
        DOMBuilder domb = new DOMBuilder();
        Document[] docs = new Document[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            docs[i] = domb.build(sources[i]);
        }
        Document result = this.doMerge(docs);
        DOMOutputter outputter = new DOMOutputter();
        try {
            return outputter.output(result);
        }
        catch (JDOMException e) {
            throw new DocumentException(result, (Throwable)e);
        }
    }

    public InputStream merge(InputStream[] sources) throws AbstractXmlMergeException {
        SAXBuilder sxb = new SAXBuilder();
        Document[] docs = new Document[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            try {
                docs[i] = sxb.build(sources[i]);
                continue;
            }
            catch (JDOMException e) {
                throw new ParseException(e);
            }
            catch (IOException ioe) {
                throw new ParseException(ioe);
            }
        }
        Document result = this.doMerge(docs);
        Format prettyFormatter = Format.getPrettyFormat();
        prettyFormatter.setLineSeparator(System.getProperty("line.separator"));
        XMLOutputter sortie = new XMLOutputter(prettyFormatter);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            sortie.output(result, (OutputStream)buffer);
        }
        catch (IOException ex) {
            throw new DocumentException(result, (Throwable)ex);
        }
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    private Document doMerge(Document[] docs) throws AbstractXmlMergeException {
        Document temporary = docs[0];
        for (int i = 1; i < docs.length; ++i) {
            if (!this.m_rootMatcher.matches(temporary.getRootElement(), docs[i].getRootElement())) {
                throw new IllegalArgumentException("Root elements do not match.");
            }
            Document output = new Document();
            if (docs[0].getDocType() != null) {
                output.setDocType((DocType)docs[0].getDocType().clone());
            }
            output.setRootElement(new Element("root"));
            this.m_rootMergeAction.perform(temporary.getRootElement(), docs[i].getRootElement(), output.getRootElement());
            Element root = (Element)output.getRootElement().getChildren().get(0);
            root.detach();
            temporary.setRootElement(root);
        }
        return temporary;
    }
}

