# -------------------------------------------------
# Project for Tickstill
# -------------------------------------------------

DESTDIR = output
TEMPLATE = app
CONFIG -= app_bundle
CONFIG += debug_and_release

DEFINES += WITH_PHONON
QT += phonon

CONFIG(debug, debug|release) {
    TARGET = tickstill-dbg
} else {
    TARGET = tickstill
}

DEPENDPATH = sources
INCLUDEPATH += sources

!mac: {
INCLUDEPATH += /usr/include/glib-2.0 /usr/lib/glib-2.0/include \
               /usr/include/dbus-1.0 /usr/include/glib-2.0 /usr/lib/glib-2.0/include /usr/lib/dbus-1.0/include
LIBS += -L/usr/local/lib \
        -lglib-2.0 \
        -losso -ldbus-glib-1 -ldbus-1 -lpthread -lgobject-2.0 -lglib-2.0
}

# Temp folders
MOC_DIR = temp/moc
OBJECTS_DIR = temp/obj
RCC_DIR = temp/rcc
UI_DIR = temp/ui

# Project files
SOURCES +=      main.cpp \
                mainwindow.cpp \
                numberitem.cpp \
                rotator.cpp \
                debugtext.cpp \
                custombutton.cpp

HEADERS +=      mainwindow.h \
                numberitem.h \
                rotator.h \
                debugtext.h \
                custombutton.h

RESOURCES +=    resources/tickstill.qrc

OTHER_FILES +=  debian/* \
                sources/tickstill.desktop

TRANSLATIONS += translations/*.ts

QMAKE_POST_LINK = mkdir -p $$DESTDIR/resources; cp $$PWD/resources/buzz.wav $$DESTDIR/resources;

CONFIG(release, debug|release) {
    QMAKE_POST_LINK += strip $$DESTDIR/tickstill;
}

include(tickstill.pri)
