/*
** Copyright (c) 2009  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#ifndef ROTATOR_H
#define ROTATOR_H

#include <QObject>
#include <QGraphicsScene>
#include <QTimer>
#include <QTime>
#include "numberitem.h"

class CRotator : public QObject
{
    Q_OBJECT

public:
    CRotator(QObject* pParent = 0);

    void buildScene(QGraphicsScene* pScene, const QRect& rect, QPixmap pixmapNumbers);
    void adjustScene(const QRect& rect);

    void enableEditMode(bool bEnable);
    void setValue(int value);
    int value() { return m_Value; }

    virtual void mouseMoveEvent(QGraphicsSceneMouseEvent* pEvent);
    virtual void mousePressEvent(QGraphicsSceneMouseEvent* pEvent);
    virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent* pEvent);

signals:
    void valueChanged(int value);

public slots:
    void onTimeout();

private:
    void setOffset(int offset);
    void calculateSpeed(QPointF pos);

    QList<CNumberItem*> m_Numbers;      ///< List of number items shown by the rotator
    int m_Value;                        ///< The current value the rotator shows
    int m_MaxValue;                     ///< The maximum value
    int m_Offset;                       ///< The current rotation offset
    bool m_bEditMode;                   ///< True when in edit mode

    int m_DragStartOffset;              ///< The offset when the dragging was started
    QPointF m_DragStartPos;             ///< The drag start position
    QTimer m_DragTimer;                 ///< The timer to check the dragging

    struct TimePos
    {
        QPointF pos;
        QTime time;
    };
    QList<TimePos> m_TimePosArray;

    qreal m_Speed;                      ///< The current rotating speed
};

#endif // ROTATOR_H
