/*
    A Qt game based on Tic Tac Toe for Maemo
    Copyright (C) 2010  Victor Blazquez Francisco <victor.blazquez@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "machineia.h"
#include <QDebug>

#include <ctime>
#include <cstdlib>
#include <QTime>

MachineIA::MachineIA() : nivel(0)
{
	QTime time = QTime::currentTime();
	qsrand((uint)time.msec());
}

void MachineIA::updateMatrix(int p[][3])
{
	for (int i = 0; i< 3 ; ++i) 
	{
		for (int j = 0 ; j < 3 ; ++j) 
			matrix[i][j] = p[i][j];
	}
}

int MachineIA::bestPosition()
{
	if (nivel == EasyLevel)
		return easyLevel();
	if (nivel == HardLevel)
		return hardLevel();
}

int MachineIA::easyLevel()
{
	bool salir = false;
	int rnda;

	do 
	{
		rnda = int((double(qrand())/RAND_MAX)*9);
		if (matrix[rnda/3][rnda%3] == Empty) {
			salir = true;
		}
	} while (!salir);
	
	return rnda;
}

int MachineIA::hardLevel()
{
	int bestCandidate;
	bool vacio = true;
	
	for (int i=0 ; i<3 ; i++)
		for (int j=0 ; j<3 ; j++)
			if (matrix[i][j] != Empty)
				vacio = false;
	
	if (vacio)
		bestCandidate = int((double(rand())/RAND_MAX)*9);
	else
	{
		int tmp[3][3];
		for (int i=0 ; i<3 ; ++i) {
			for (int j=0 ; j<3 ; ++j) {
				tmp[i][j] = 0;
			}
		}
		
		for (int i=0 ; i<3 ; ++i) {
			for (int j=0 ; j<3 ; ++j) {
				if (matrix[i][j] == Empty) {
					// Cross = maquina  // Circle = jugador
					/*	0	1	2	*/
					/*	3	4	5	*/
					/*	6	7	8	*/
					// Filas
					if (matrix[(i+1)%3][j] == Machine && matrix[(i+2)%3][j] == Machine)
						tmp[i][j] += 10000;
					else if (matrix[(i+1)%3][j] == Human && matrix[(i+2)%3][j] == Human) 
						tmp[i][j] += 3000;
					
					else if (matrix[(i+1)%3][j] == Machine && matrix[(i+2)%3][j] == Empty)
						tmp[i][j] += 500; 
					else if (matrix[(i+1)%3][j] == Empty && matrix[(i+2)%3][j] == Machine)
						tmp[i][j] += 500; 
					
					else if (matrix[(i+1)%3][j] == Empty && matrix[(i+2)%3][j] == Empty)
						tmp[i][j] += 250;  
					
					else if (matrix[(i+1)%3][j] == Empty && matrix[(i+2)%3][j] == Human)
						tmp[i][j] += -250;
					else if (matrix[(i+1)%3][j] == Human && matrix[(i+2)%3][j] == Empty)
						tmp[i][j] += -250;
					else if (matrix[(i+1)%3][j] == Machine && matrix[(i+2)%3][j] == Human)
						tmp[i][j] += -500;
					else if (matrix[(i+1)%3][j] == Human && matrix[(i+2)%3][j] == Machine)
						tmp[i][j] += -500;

					
					// Columnas
					if (matrix[i][(j+1)%3] == Machine && matrix[i][(j+2)%3] == Machine)
						tmp[i][j] += 10000;
					if (matrix[i][(j+1)%3] == Human && matrix[i][(j+2)%3] == Human)
						tmp[i][j] += 3000;
					
					else if (matrix[i][(j+1)%3] == Machine && matrix[i][(j+2)%3] == Empty)
						tmp[i][j] += 500;
					else if (matrix[i][(j+1)%3] == Empty && matrix[i][(j+2)%3] == Machine) 
						tmp[i][j] += 500;
					
					else if (matrix[i][(j+1)%3] == Empty && matrix[i][(j+2)%3] == Empty)
						tmp[i][j] += 250;
					
					else if (matrix[i][(j+1)%3] == Empty && matrix[i][(j+2)%3] == Human) 
						tmp[i][j] += -250;
					else if (matrix[i][(j+1)%3] == Human && matrix[i][(j+2)%3] == Empty) 
						tmp[i][j] += -250;
					else if (matrix[i][(j+1)%3] == Machine && matrix[i][(j+2)%3] == Human) 
						tmp[i][j] += -500;
					else if (matrix[i][(j+1)%3] == Human && matrix[i][(j+2)%3] == Machine) 
						tmp[i][j] += -500;


					// Diagonales
					// 00	01	02
					// 10	11	12
					// 20	21	22
					if ( i == 0 && j == 0) 
					{
						if (matrix[1][1] == Machine && matrix[2][2] == Machine) 
							tmp[i][j] += 10000;
						if (matrix[1][1] == Human && matrix[2][2] == Human) 
							tmp[i][j] += 3000;
						
						if (matrix[1][1] == Machine && matrix[2][2] == Empty) 
							tmp[i][j] += 500;
						if (matrix[1][1] == Empty && matrix[2][2] == Machine) 
							tmp[i][j] += 500;
						
						if (matrix[1][1] == Empty && matrix[2][2] == Empty) 
							tmp[i][j] += 250;
						
						if (matrix[1][1] == Human && matrix[2][2] == Empty) 
							tmp[i][j] += -250;
						if (matrix[1][1] == Empty && matrix[2][2] == Human) 
							tmp[i][j] += -250;
						if (matrix[1][1] == Machine && matrix[2][2] == Human) 
							tmp[i][j] += -500;
						if (matrix[1][1] == Human && matrix[2][2] == Machine) 
							tmp[i][j] += -500;
					}
					if ( i == 2 && j == 2) 
					{
						if (matrix[1][1] == Machine && matrix[0][0] == Machine) 
							tmp[i][j] += 10000;
						if (matrix[1][1] == Human && matrix[0][0] == Human) 
							tmp[i][j] += 3000;
						
						if (matrix[1][1] == Machine && matrix[0][0] == Empty) 
							tmp[i][j] += 500;
						if (matrix[1][1] == Empty && matrix[0][0] == Machine) 
							tmp[i][j] += 500;
						
						if (matrix[1][1] == Empty && matrix[0][0] == Empty) 
							tmp[i][j] += 250;
						
						if (matrix[1][1] == Human && matrix[0][0] == Empty) 
							tmp[i][j] += -250;
						if (matrix[1][1] == Empty && matrix[0][0] == Human) 
							tmp[i][j] += -250;
						if (matrix[1][1] == Machine && matrix[0][0] == Human) 
							tmp[i][j] += -500;
						if (matrix[1][1] == Human && matrix[0][0] == Machine) 
							tmp[i][j] += -500;
					}
					if ( i == 0 && j == 2) 
					{
						if (matrix[1][1] == Machine && matrix[0][2] == Machine) 
							tmp[i][j] += 10000;
						if (matrix[1][1] == Human && matrix[0][2] == Human) 
							tmp[i][j] += 3000;
						
						if (matrix[1][1] == Machine && matrix[0][2] == Empty) 
							tmp[i][j] += 500;
						if (matrix[1][1] == Empty && matrix[0][2] == Machine) 
							tmp[i][j] += 500;
						
						if (matrix[1][1] == Empty && matrix[0][2] == Empty) 
							tmp[i][j] += 250;
						
						if (matrix[1][1] == Human && matrix[0][2] == Empty) 
							tmp[i][j] += -250;
						if (matrix[1][1] == Empty && matrix[0][2] == Human) 
							tmp[i][j] += -250;
						if (matrix[1][1] == Machine && matrix[0][2] == Human) 
							tmp[i][j] += -500;
						if (matrix[1][1] == Human && matrix[0][2] == Machine) 
							tmp[i][j] += -500;
					}
					if ( i == 2 && j == 0) 
					{
						if (matrix[1][1] == Machine && matrix[2][0] == Machine) 
							tmp[i][j] += 10000;
						if (matrix[1][1] == Human && matrix[2][0] == Human) 
							tmp[i][j] += 3000;
						
						if (matrix[1][1] == Machine && matrix[2][0] == Empty) 
							tmp[i][j] += 500;
						if (matrix[1][1] == Empty && matrix[2][0] == Machine) 
							tmp[i][j] += 500;
						
						if (matrix[1][1] == Empty && matrix[2][0] == Empty) 
							tmp[i][j] += 250;
						
						if (matrix[1][1] == Human && matrix[2][0] == Empty) 
							tmp[i][j] += -250;
						if (matrix[1][1] == Empty && matrix[2][0] == Human) 
							tmp[i][j] += -250;
						if (matrix[1][1] == Machine && matrix[2][0] == Human) 
							tmp[i][j] += -500;
						if (matrix[1][1] == Human && matrix[2][0] == Machine) 
							tmp[i][j] += -500;
					}
					if ( i == 1 && j == 1) 
					{
						if (matrix[0][0] == Machine && matrix[2][2] == Machine) 
							tmp[i][j] += 10000;
						if (matrix[0][0] == Human && matrix[2][2] == Human) 
							tmp[i][j] += 3000;
						
						if (matrix[0][0] == Machine && matrix[2][2] == Empty) 
							tmp[i][j] += 500;
						if (matrix[0][0] == Empty && matrix[2][2] == Machine) 
							tmp[i][j] += 500;
						
						if (matrix[0][0] == Empty && matrix[2][2] == Empty) 
							tmp[i][j] += 250;
						
						if (matrix[0][0] == Human && matrix[2][2] == Empty) 
							tmp[i][j] += -250;
						if (matrix[0][0] == Empty && matrix[2][2] == Human) 
							tmp[i][j] += -250;
						if (matrix[0][0] == Machine && matrix[2][2] == Human) 
							tmp[i][j] += -500;
						if (matrix[0][0] == Human && matrix[2][2] == Machine) 
							tmp[i][j] += -500;
						
						//Diagonal opuesta
						if (matrix[0][2] == Machine && matrix[2][0] == Machine) 
							tmp[i][j] += 10000;
						if (matrix[0][2] == Human && matrix[2][0] == Human) 
							tmp[i][j] += 3000;
						
						if (matrix[0][2] == Machine && matrix[2][0] == Empty) 
							tmp[i][j] += 500;
						if (matrix[0][2] == Empty && matrix[2][0] == Machine) 
							tmp[i][j] += 500;
						
						if (matrix[0][2] == Empty && matrix[2][0] == Empty) 
							tmp[i][j] += 250;
						
						if (matrix[0][2] == Human && matrix[2][0] == Empty) 
							tmp[i][j] += -250;
						if (matrix[0][2] == Empty && matrix[2][0] == Human) 
							tmp[i][j] += -250;
						if (matrix[0][2] == Machine && matrix[2][0] == Human) 
							tmp[i][j] += -500;
						if (matrix[0][2] == Human && matrix[2][0] == Machine) 
							tmp[i][j] += -500;
					}
				}
				else
					tmp[i][j] = -10000;
			}
		}
		if (matrix[1][1] == Empty) 
			tmp[1][1] += 500;
		
		int* p = &tmp[0][0];
		int max = *p++;
		int otroIgual = 0;
		bestCandidate = 0;
		for (int i=1 ; i<9 ; ++i){
			if (max == *p) {
				otroIgual++;
			}
			if (max < *p) {
				max = *p;
				bestCandidate = i;
				otroIgual = 0;
			}
			p++;
		}
		bool salir = false;
		int rnda;
		while (!salir) {
			rnda = int((double(rand())/RAND_MAX)*9);
			if (tmp[rnda/3][rnda%3] == max) {
				bestCandidate = rnda;
				salir = true;
			}
		}
	}
// 	qDebug()<< "--------------";
// 	qDebug()<< tmp[0][0] << "\t" << tmp[0][1] << "\t" << tmp[0][2] << "\t-\t" << matrix[0][0] << "\t" << matrix[0][1] << "\t" << matrix[0][2];
// 	qDebug()<< tmp[1][0] << "\t" << tmp[1][1] << "\t" << tmp[1][2] << "\t-\t" << matrix[1][0] << "\t" << matrix[1][1] << "\t" << matrix[1][2];
// 	qDebug()<< tmp[2][0] << "\t" << tmp[2][1] << "\t" << tmp[2][2] << "\t-\t" << matrix[2][0] << "\t" << matrix[2][1] << "\t" << matrix[2][2];
	
	return bestCandidate;
}

int MachineIA::level()
{
	return nivel;
}


void MachineIA::setLevel(int _nivel)
{
	srand((unsigned)time(0)); 
	nivel = _nivel;
	if (nivel >= MaxLevel)
		nivel = EasyLevel;
}
