/*
    A Qt game based on Tic Tac Toe for Maemo
    Copyright (C) 2010  Victor Blazquez Francisco <victor.blazquez@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "finalline.h"

#include <QPainter>

FinalLine::FinalLine(QGraphicsItem* parent, Qt::WindowFlags wFlags): QGraphicsWidget(parent, wFlags)
{
	update();
}

void FinalLine::setPoints(QPoint _init, QPoint _end)
{
	init = _init;
	end = _end;
	update();
}

void FinalLine::paint(QPainter* painter, const QStyleOptionGraphicsItem* option, QWidget* widget)
{
	QPen p(Qt::SolidLine);
	p.setColor(Qt::white);
	p.setWidth(10);
	painter->setPen(p);
	painter->drawLine(init, end);
}
