/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/*
* aumiks 0.1
*/

#pragma once

#include <ting/debug.hpp>
#include <ting/Array.hpp>
#include <ting/types.hpp>

#include "config.hpp"

#include "Sample.hpp"

namespace aumiks{

class SamplePulseGen{
	//sample data
	const ting::Ref<Sample> smp;

	real curPhase;
	real phaseStep;

public:
	SamplePulseGen(const ting::Ref<Sample> sample) :
			smp(sample),
			curPhase(0),
			phaseStep(1)
	{}

	inline aumiks::real Tick(){
		ASSERT(this->smp)
		if(this->curPhase >= real(this->smp->data.Size())){
			return 0;
		}
		
		ASSERT(0 <= this->curPhase && this->curPhase < real(this->smp->data.Size()))
		real ret = this->smp->data[unsigned(this->curPhase)];
		this->curPhase += this->phaseStep;
		return ret;
	}

	inline void Init(){
		this->curPhase = 0;
	}

	inline void SetFrequency(float freq){
		ASSERT(this->smp)
		this->phaseStep = real(freq) / this->smp->freq;
	}
};

}//~namespace
