// (c) Ivan Gagis
// e-mail: igagis@gmail.com
// Version: 1

// Description:
//	Client class

#pragma once

#include <cliser/srv/Client.hpp>

#include "Cast.hpp"



class Client : public cliser::Client{
//	friend class Therver;

public:
	enum EState{
		IDLE,
		PLAYING,
		LISTENING,
		WAITING_FOR_LISTENING
	};

private:
	EState state;

public:
	inline EState GetState()const{
		return this->state;
	}

	void SetState(EState newState);

	T_CastsIter cast; //for PLAYING and LISTENING states

	inline bool IsIdle()const{
		return this->state == IDLE;
	}

	inline bool IsWaitingForListening()const{
		return this->state == WAITING_FOR_LISTENING;
	}

	inline bool IsListening()const{
		return this->state == LISTENING;
	}

	inline bool IsPlaying()const{
		return this->state == PLAYING;
	}
	
public:
	Client() :
			state(IDLE),
			networkState(CONNECTED)
	{}


	enum ENetworkState{
		CONNECTED,
		LOGGING_IN,
		LOGGED_IN,
		DISCONNECTED
	};


	inline void SetNetworkState(ENetworkState s){
		this->networkState = s;
	}

	inline ENetworkState GetNetworkState()const{
		return this->networkState;
	}

	inline bool IsLoggedIn()const{
		return this->GetNetworkState() == LOGGED_IN;
	}

	inline bool IsNotLoggedIn()const{
		return !this->IsLoggedIn();
	}
private:
	ENetworkState networkState;

public:
	std::string username;
	std::string password;

	void SendLoginResult(bool success);

	void SendPlayingPlayer(const std::string& playerNickname);

	void SendStopListening();

	enum ERegisterRes{
		REGISTERRES_SUCCESS,
		REGISTERRES_USERNAME_ALREADY_TAKEN,
		REGISTERRES_SOME_ERROR
	};
	void SendRegisterResult(ERegisterRes result);
};


