// (c) Ivan Gagis
// e-mail: igagis@gmail.com
// Version: 1

// Description:
//

#include <ting/debug.hpp>
#include <ting/Array.hpp>
#include <ting/types.hpp>

#include "Client.hpp"


using namespace ting;



void Client::SendLoginResult(bool success){
	Array<ting::u8> p(2);

	p[0] = 0;
	p[1] = success ? 0 : 1;

	this->SendNetworkData_ts(p);
}



void Client::SendPlayingPlayer(const std::string& playerNickname){
	Array<ting::u8> p(1 + 2 + playerNickname.size());

	unsigned i = 0;
	p[i] = 0x01;
	++i;

	ting::ToNetworkFormat16(playerNickname.size(), &p[i]);
	i += 2;

	memcpy(&p[i], playerNickname.c_str(), playerNickname.size());
	ASSERT(i + playerNickname.size() == p.Size())

	this->SendNetworkData_ts(p);
}



void Client::SendStopListening(){
	Array<ting::u8> p(1);

	p[0] = 0x02;

	this->SendNetworkData_ts(p);
}



void Client::SendRegisterResult(ERegisterRes result){
	Array<ting::u8> p(2);

	p[0] = 0x04; //register response

	switch(result){
		case REGISTERRES_SUCCESS:
			p[1] = 0;
			break;
		case REGISTERRES_USERNAME_ALREADY_TAKEN:
			p[1] = 1;
			break;
		default:
		case REGISTERRES_SOME_ERROR:
			p[1] = 3;
			break;
	}

	//send response to client
	this->SendNetworkData_ts(p);
}



void Client::SetState(EState newState){
	this->state = newState;
}

