/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/* 
 * File:   MainWindow.hpp
 * Author: ivan
 *
 * Created on February 23, 2009, 1:17 AM
 */

#pragma once

#ifndef M_NON_MAEMO_LINUX
#include <hildonmm/window.h>
#else
#include <gtkmm/window.h>
#endif

#include <gtkmm/notebook.h>
#include <gtkmm/menu.h>

#include <ting/types.hpp>
#include <ting/Singleton.hpp>
#include <ting/Signal.hpp>
#include <aumiks/synth/synth.hpp>

#include "MainMenuView.hpp"
#include "ThereminView.hpp"
#include "ListenView.hpp"
#include "OptionsDialog.hpp"
#include "Preferences.hpp"



//forward declarations
class MainThread;


class MainWindow :
		public ting::Singleton<MainWindow>,
		public
#ifndef M_NON_MAEMO_LINUX
		Hildon::Window
#else
		Gtk::Window
#endif
{
	bool isFullscreen;

	Gtk::Menu mainMenu;
	Gtk::MenuItem optionsMenuItem;
	Gtk::MenuItem exitMenuItem;
	Gtk::MenuItem aboutMenuItem;

	Gtk::Notebook notebook;

	MainMenuView mainMenuView;
	ThereminView thereminView;
	ListenView listenView;

	ting::Signal0 openOptionsSignal;

	void OpenOptionsDialog(){
		this->openOptionsSignal.Emit();
	}

public:
	MainWindow();
	~MainWindow(){
//		TRACE(<< "~MainWindow(): invoked" << std::endl)
	}

	void ShowMainMenuScreen(){
		this->notebook.set_current_page(0);
		this->openOptionsSignal.DisconnectAll();
	}

	void ShowThereminScreen(){
		this->notebook.set_current_page(1);
		this->openOptionsSignal.DisconnectAll();
		this->openOptionsSignal.Connect(
				&this->thereminView,
				&ThereminView::ShowOptionsDialog
			);
	}

	void ShowListenOthersScreen(){
		this->notebook.set_current_page(2);
		this->openOptionsSignal.DisconnectAll();
	}

	bool OnKeyPress(GdkEventKey* event);
//	void OnKeyPress_Notify(GdkEventKey* event);

	void ShowAboutDialog();

	void Exit();
};


