#include <iostream>
#include <string>
#include <cstdlib>

#include <ting/Socket.hpp>
#include <ting/Timer.hpp>

#include "Therver.hpp"


using namespace ting;



int main(int argc, char *argv[]) throw(){
	try{
		if(argc < 2){
			std::cout << "ERROR: need path to data directory" << std::endl;
			return 0;
		}

		std::string dataDir;

		ASSERT(argc >= 2);
		dataDir = std::string(argv[1]) + "/";

		u16 port = 13666;

		if(argc >= 3){
			port = u16(atoi(argv[2]));
		}

		ASSERT(dataDir.size() > 0)

		//initialize timer library
		ting::TimerLib timerLibrary;

        //initialize network library
        ting::SocketLib socketLib;
        
        {
            Therver s(port, dataDir);
            s.MainLoop();
        }
        
    }//~try
    catch(ting::Exc& exc){
        LOG(<<"!!!Global exception caught!!!\n"<<"\t"<<exc.What()<<std::endl<<"Exiting."<<std::endl)
    }
    catch(std::bad_alloc& exc){
        LOG(<<"[!!] Memory allocation error!"<<"\n\t!!!Global exception!!! Exiting."<<std::endl)
    }
    catch(std::exception& exc){
        LOG(<<"[!!] std::exception caught!"<<"\n\t!!!Global exception!!! Exiting."<<std::endl)
    }
    catch(...){
        LOG(<<"[!!] Unknown exception caught!"<<"\n\t!!!Global exception!!! Exiting."<<std::endl)
    }
    LOG(<<"Bye!"<<std::endl)
    return 0; //exit
};
