/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/* 
 * File:   NetworkSettingsDialog.hpp
 * Author: ivan
 *
 * Created on February 23, 2009, 4:10 PM
 */

#pragma once



#include <gtkmm/dialog.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/entry.h>
#include <gtkmm/button.h>
#include <gtkmm/label.h>
#include <glibmm/dispatcher.h>

#include "MainThread.hpp"



class NetworkSettingsDialog : public Gtk::Dialog, public MainThread::NetworkStateListener{

	Gtk::CheckButton broadcastMusicCheckbox;

	Gtk::CheckButton autologinCheckbox;

	Gtk::Entry usernameEntryField;
	Gtk::Entry passwordEntryField;

	Gtk::Button loginButton;
	Gtk::Button logoutButton;
	Gtk::Label statusLabel;

	
	ting::Mutex dispatcherArgMutex;
	std::deque<MainThread::ENetworkState> dispatcherArg;
	ting::uint dispatcherConnection;

	void DispatcherHandler();


	void SetButtonState(MainThread::ENetworkState st);


public:
	NetworkSettingsDialog(Gtk::Window &parent);
	~NetworkSettingsDialog();


private:
	void RegisterNewAccount();

	void OnOkPressed();

	void OnLoginPressed();

	void OnLogoutPressed();


	//NOTE: this method is called form different thread than UI trhead
	//override
	virtual void OnStateChange(MainThread::ENetworkState newState);
};

