#include <iostream>
#include <string>

#include <ting/Socket.hpp>
#include <ting/Timer.hpp>

#include "Therver.hpp"

#include "SQLite.hpp"



int main(int argc, char *argv[]) throw(){
	try{

		//TODO: remove this redundant commented code
//		sqlite::Database db("users.db");

		//db.CreateTable("users", "login TEXT, password TEXT");

//		db.Delete("users", "pw = 'test'");
//		db.Insert("users", "", "'testUser', 'test'");
//		db.Update("users", "login = 'testUserUpdated'", "login = 'testUser'");
//		sqlite::Cursor cur = db.Query("users", "un", "un = 'uuu'");

//		TRACE(<< "cur.MoveToNext() = " << cur.MoveToNext() << std::endl)
//		TRACE(<< "cur.GetText(un) = " << cur.GetText("un") << std::endl)
//		TRACE(<< "cur.MoveToNext() = " << cur.MoveToNext() << std::endl)
//		TRACE(<< "cur.MoveToNext() = " << cur.MoveToNext() << std::endl)

		if(argc != 2){
			std::cout << "ERROR: need path to data directory" << std::endl;
			return 0;
		}

		std::string dataDir;

		if(argc == 2){
			dataDir = std::string(argv[1]) + "/";
		}else{
			ASSERT_ALWAYS(false)
		}

		ASSERT(dataDir.size() > 0)

		//initialize timer library
		ting::TimerLib timerLibrary;

        //initialize network library
        ting::SocketLib socketLib;
        
        {
            Therver s(dataDir);
            s.MainLoop();
        }
        
    }//~try
    catch(ting::Exc& exc){
        LOG(<<"!!!Global exception caught!!!\n"<<"\t"<<exc.What()<<std::endl<<"Exiting."<<std::endl)
    }
    catch(std::bad_alloc& exc){
        LOG(<<"[!!] Memory allocation error!"<<"\n\t!!!Global exception!!! Exiting."<<std::endl)
    }
    catch(std::exception& exc){
        LOG(<<"[!!] std::exception caught!"<<"\n\t!!!Global exception!!! Exiting."<<std::endl)
    }
    catch(...){
        LOG(<<"[!!] Unknown exception caught!"<<"\n\t!!!Global exception!!! Exiting."<<std::endl)
    }
    LOG(<<"Bye!"<<std::endl)
    return 0; //exit
};
