// (c) Ivan Gagis
// e-mail: igagis@gmail.com
// Version: 1

// Description:
//	Client class

#pragma once

#include <cliser/srv/Client.hpp>

#include "Cast.hpp"



class Client : public cliser::Client{
	friend class Therver;

public:
	bool isPlaying;
	T_CastsIter playingCast;

	bool isListening;
	T_CastsIter listeningCast;


	
public:
	Client() :
			isPlaying(false),
			isListening(false),
			state(CONNECTED)
	{}


	enum EState{
		CONNECTED,
		LOGGING_IN,
		LOGGED_IN,
		DISCONNECTED
	};


	inline void SetState(EState s){
		this->state = s;
	}

	inline EState GetState()const{
		return this->state;
	}

	inline bool IsLoggedIn()const{
		return this->GetState() == LOGGED_IN;
	}

	inline bool IsNotLoggedIn()const{
		return !this->IsLoggedIn();
	}
private:
	EState state;

public:
	std::string username;
	std::string password;

	void SendLoginResult(bool success);

	void SendPlayingPlayer(const std::string& playerNickname);

	void SendStopListening();

	enum ERegisterRes{
		REGISTERRES_SUCCESS,
		REGISTERRES_USERNAME_ALREADY_TAKEN,
		REGISTERRES_SOME_ERROR
	};
	void SendRegisterResult(ERegisterRes result);
};


