#ifndef SHACALCULATOR_H
#define SHACALCULATOR_H

#define SHA1_SET_KEY(next,previous,current) \
{ \
    for(size_t i = 0;i < sizeof(sha1_key) / sizeof(unsigned long);i += 4) { \
        next.W[i+0] = (previous.W[i+0] ^ current.W[i+0]); \
        next.W[i+1] = (previous.W[i+1] ^ current.W[i+1]); \
        next.W[i+2] = (previous.W[i+2] ^ current.W[i+2]); \
        next.W[i+3] = (previous.W[i+3] ^ current.W[i+3]); \
    } \
}

typedef struct _SHA_MSG {
    unsigned long W[80];
} sha1_key;


const unsigned char charTable[]="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";


class ShaCalculator
{

    void expand(sha1_key *dst, sha1_key *src);
    void init_yy(void);
    void init_ww(void);
    void init_xxx(void);

public:
    ShaCalculator();
    void sha1_block(void);
    unsigned long sha1_hash[5];
    sha1_key yy_schedules[16];
    sha1_key ww_schedules[64];
    sha1_key xxx_schedules[4][64];
    sha1_key x1_buffer;
    sha1_key x2_buffer;
    sha1_key x3_buffer;
    sha1_key *x1_schedules;
    sha1_key *x2_schedules;
    sha1_key *x3_schedules;
};

#endif // SHACALCULATOR_H
