#ifndef SQUEEZEPLAYER_H
#define SQUEEZEPLAYER_H

#include <QObject>
#include "metatypes.h"

class squeezePlayer : public QObject
{
    Q_OBJECT

public:
    explicit squeezePlayer(QObject *parent = 0);

    void setPlayerID(QString newID) {playerID = newID;}
    void setPlayerIP(QString newIP) {playerIP = newIP;}
    void setPlayerName(QString newName) {playerName = newName;}
    void setPlayerModel(QString newModel) {playerModel = newModel;}
    void setCurrentSongID(QString songID) {currentSongID = songID;}
    void setCurrentArtist(QString artist) {currentArtist = artist;}
    void setCurrentTitle(QString title) {currentTitle = title;}
    void setCurrentAlbum(QString album) {currentAlbum = album;}
    void setCurrentGenre(QString genre) {currentGenre = genre;}
    void setCurrentMode(QString mode) {currentMode = mode;}
    void setPower(bool powerOn) {power = powerOn;}
    void setCurrentDuration(float duration) {currentDuration = duration;}
    void setCurrentTime(float time) {currentTime = time;}
    void setCurrentVolume(quint16 volume) {currentVolume = volume;}
    void setCurrentAlbumArtURL(QString albumArtURL) {currentAlbumArtURL = albumArtURL;}
    void setRemoteAlbumArtURL(QString albumArtURL) {remoteAlbumArtURL = albumArtURL;}
    void setCurrentAlbumArt(QPixmap *albumArt) {currentAlbumArt = albumArt;}

    QString playerID;
    QString playerIP;
    QString playerName;
    QString playerModel;
    QString currentSongID;
    QString currentTitle;
    QString currentArtist;
    QString currentAlbum;
    QString currentGenre;
    quint16 currentVolume;
    float currentDuration;
    float currentTime;
    bool power;
    QString currentAlbumArtURL;
    QString remoteAlbumArtURL;
    QString currentMode;
    QPixmap *currentAlbumArt;
    QString remoteTitle;
    QString playlistRepeat;
    QString playlistShuffle;
    QString playlistMode;
    quint16 playlistTracks;
    quint16 playlistIndex;
    quint16 prevPlaylistIndex;
    QString masterPlayerID;
    QStringList slavePlayerID;
    QList<squeezePlayer*> slavePlayers;
    squeezePlayer *masterPlayer;

    bool isRemote;

    bool isMaster;
    bool isSlave;
    bool updateAlbumArt;
    bool songChanged;

public slots:
signals:
private:
};


#endif // SQUEEZEPLAYER_H
