#ifndef SUMMARYWINDOWDESKTOP_H
#define SUMMARYWINDOWDESKTOP_H

#include <QPushButton>
#include <QLabel>
#include <QVBoxLayout>
#include "conceptschart.h"
#include "expensesgraph.h"
#include <QAction>
#include <QFrame>
#include <QComboBox>
#include <QTabWidget>
#include "summarywindow.h"

class SummaryWindowDesktop : public SummaryWindow
{
        Q_OBJECT
 public:
        SummaryWindowDesktop(int minYear,
                             int minMonth,
                             int maxYear,
                             int maxMonth,
                             QWidget *parent = 0);
        ~SummaryWindowDesktop();
        void setSummaryData(SummaryData *data);
        QSize minimumSizeHint() const;
        QSize sizeHint() const;

 protected:
        void mousePressEvent(QMouseEvent *event);

 private slots:
        void loadButtonClicked();

 private:
        void message(QString text);

        /* period stuff */
        QLabel *fromLabel;
        QLabel *toLabel;
        QVBoxLayout *vbox;

        int _minYear;
        int _minMonth;
        int _maxYear;
        int _maxMonth;
        int _startYear;
        int _startMonth;
        int _endYear;
        int _endMonth;
        QPushButton *loadButton;

        QComboBox *startYearCombo;
        QComboBox *startMonthCombo;
        QComboBox *endYearCombo;
        QComboBox *endMonthCombo;

        QTabWidget *tabWidget;

        /* statistics stuff */
        QFrame *statsBox;
        QLabel *totalBudget;
        QLabel *totalExpense;
        QLabel *totalSaved;
        QLabel *minExpense;
        QLabel *maxExpense;
        QLabel *averageExpense;
        QLabel *minSaved;
        QLabel *maxSaved;
        QLabel *averageSaved;

        /* items stuff */
        ConceptsChart *chart;

        QFrame *graphBox;
        QLabel *viewLabel;
        ExpensesGraph *graph;

        SummaryData *summaryData;

};
#endif
