#ifndef SCHEDULEDDETAILSDIALOGDESKTOP_H
#define SCHEDULEDDETAILSDIALOGDESKTOP_H

#include <QLineEdit>
#include <QList>
#include <QDate>
#include "concept.h"
#include <QStandardItemModel>
#include <QListView>
#include <QDialog>
#include <QItemSelectionModel>
#include <QDialogButtonBox>
#include <QComboBox>
#include "scheduleddetailsdialog.h"

class ScheduledDetailsDialogDesktop : public ScheduledDetailsDialog
{
        Q_OBJECT
 public:
        ScheduledDetailsDialogDesktop(QStandardItemModel *concepts,
                                      QWidget *parent = 0,
                                      Qt::WindowFlags f = 0);

        ScheduledDetailsDialogDesktop(QStandardItemModel *concepts,
                                      QStandardItemModel *scheduled,
                                      int row,
                                      QWidget *parent = 0,
                                      Qt::WindowFlags f = 0);

        ~ScheduledDetailsDialogDesktop();
        QSize minimumSizeHint() const;
        QSize sizeHint() const;

 private slots:
        void checkValues();
        void deleteClicked();

 private:
        void buildUI (QStandardItemModel *concepts);
        void message(QString text);

        QListView *day;
        QComboBox *concept;
        QListView *month;

        QLineEdit *amount;
        QLineEdit *description;
        int scheduledId;
        int monthSelectionAsInt;
        int daySelectionAsInt;
        int previousFrecuency;

        QDialog *monthDialog;
        QStandardItemModel *monthModel;
        QListView *monthList;
        QItemSelectionModel *monthSelection;

        QDialogButtonBox *box;

        bool newScheduled;
};
#endif
