#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QListView>
#include <QTreeView>
#include <QPushButton>
#include "accountsdialogdesktop.h"

AccountsDialogDesktop::AccountsDialogDesktop(QStandardItemModel *accounts,
                                             QWidget *parent,
                                             Qt::WindowFlags f)
        : AccountsDialog (parent, f)
{
        setWindowTitle(tr("Accounts"));

        QVBoxLayout *layout = new QVBoxLayout (this);

        QTreeView *tree = new QTreeView();
        tree->setModel(accounts);
        tree->setColumnHidden(0, true);
        tree->setColumnWidth(1, 220);
        tree->setColumnWidth(2, 100);
        tree->setColumnWidth(3, 0);
        tree->setIconSize(QSize(20, 20));
        tree->setUniformRowHeights(true);
        layout->addWidget(tree, 1);

        connect (tree, SIGNAL(activated(const QModelIndex&)),
                 this, SLOT(detailsSelected(const QModelIndex&)));

        QDialogButtonBox *box = new QDialogButtonBox(Qt::Horizontal);
        box->addButton(new QPushButton(tr("New")), QDialogButtonBox::AcceptRole);
        box->addButton(QDialogButtonBox::Close);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(accepted()), this, SLOT(newSelected()));
        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
}

AccountsDialogDesktop::~AccountsDialogDesktop()
{
}

void AccountsDialogDesktop::newSelected()
{
        emit newAccountSelected();
}

void AccountsDialogDesktop::detailsSelected(const QModelIndex &index)
{
        emit accountDetailsSelected(index);
}

QSize AccountsDialogDesktop::minimumSizeHint() const
{
        return QSize(400, 200);
}

QSize AccountsDialogDesktop::sizeHint() const
{
        return QSize(400, 200);
}
