/*
 * Copyright (C) 2009, Jamie McCracken (jamiecc at gnome org)
 * Copyright (C) 2010, Bundyo (bundyo at gmail.com)
 *
 * Initially written by Jamie McCracken in Genie. 
 * Converted to Vala and butchered (downgraded to Tracker 0.6, 
 * Hildonized and adapted to Maemo 5) by Bundyo.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

[DBus (name = "org.freedesktop.Tracker.Search")]
interface Search : GLib.Object {
    public abstract string[,] Query (int live_id, string category, string[] fields, string fts, string[] keywords, string query, bool sort, string[] sort_fields, bool desc, int offset, int hits) throws DBus.Error;
}

class TrackerQuery : Object {

    Search tracker;
    string _SearchTerms;
                
    public signal void SearchSettingsChanged ();
    public signal void ClearSearchResults ();

    public string SearchTerms {
        get { return  _SearchTerms; }
        set {
            if (value != null)
                _SearchTerms = value;
        }
	}
    public string Category { get; set construct; }
    public string SortField { get; set construct; }
    public string[] Fields { get; set construct; }

    construct {
        Category = "Files";
        Fields = new string[2] { "File:Name", "File:Path" };

        this.notify += (t, propety) => {
            if ((propety.name == "Category") || (propety.name == "SortField")) //  || (propety.name == "Fields")
                SearchSettingsChanged ();
            else
                if (propety.name == "SearchTerms") {
                    if ((SearchTerms == null) || (SearchTerms.length < 3))
                        ClearSearchResults ();
                    else
                        SearchSettingsChanged ();
                }
        };
	}

    public bool Connect () {

        try {
            var conn = DBus.Bus.get (DBus.BusType.SESSION);
			tracker = conn.get_object ("org.freedesktop.Tracker", "/org/freedesktop/Tracker/Search", "org.freedesktop.Tracker.Search") as Search;
        } catch (DBus.Error e) {
            print ("Cannot connect to Session bus. Error is %s", e.message);
            return false;
        } 

        return true;
    } 

	private string build_query () {
		var output = "<rdfq:Condition><rdfq:or>";
		
		foreach (string field in Fields) {
			output += "<rdfq:contains><rdfq:Property name=\""+ field +"\"/><rdf:String>"+ SearchTerms +"</rdf:String></rdfq:contains>";
		}
		
		output += "</rdfq:or></rdfq:Condition>";
		
		return output;
	}
	
	public string[] join_arrays (string[] input, string[] joiner) {
		var output = input;
		
		foreach ( string join in joiner ) {
			output += join;
		}
		
		return output;
	}

// int32:0 string:'Files' array:string:"File:Name","File:Path" string:"" array:string:"" string:'<rdfq:Condition><rdfq:or><rdfq:contains><rdfq:Property name="File:Path"/><rdf:String>text</rdf:String></rdfq:contains><rdfq:contains><rdfq:Property name="File:Name"/><rdf:String>text</rdf:String></rdfq:contains></rdfq:or></rdfq:Condition>' boolean:true array:string:"" boolean:false int32:0 int32:100

	public string[,]? NormalQuery () {
		
        string cat, query;

        if ((Category == null) || (Category == "All Files"))
            cat = "Files";
        else
            cat = Category;
            
		query = build_query();
		string[] keywords = new string[0];
		string[] sort_keywords = new string[0];
		
        try {
            return tracker.Query (0, Category, Fields, "", keywords, query, false, sort_keywords, false, 0, 100); 
        } catch (GLib.Error e) {
            print ("Dbus error : %s", e.message);
        }
        
        return null;
	}

}