#ifndef SABCONNECTOR_H
#define SABCONNECTOR_H

#include <qobject.h>
#include <qstring.h>
#include "settings.h"
#include <QNetworkAccessManager>
#include <QUrl>
#include <QNetworkRequest>
#include <QNetworkReply>

class SabConnector : public QObject
{
    Q_OBJECT

private:
    QNetworkAccessManager* nam;
    Settings* settingsobj;
    int port;
    QString address;
    QString apikey;
    QString getUrl(QString);
    QString getUrlNoXML(QString);

public:
    SabConnector();
    void refreshDownloads();
    void refreshHistory();
    QString getVersion(QString);
    void addNZB(QString);
    int testConnection(QString, QString, QString);

public slots:
    void finishedStatus(QNetworkReply*);
signals:
    void updateLabelReady(QString, QString);
    void downloadListReady(QMap<QString,QMap<QString,QString > >);
    void historyListReady(QMap<QString,QMap<QString,QString > >);
    void errorOccured(QString);

};

#endif // SABCONNECTOR_H
