#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "sabconnector.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    SabConnector sc;
    QMenu *menuSettings;
    QString ucfirst(const QString);

private slots:
    void on_pbHistory_clicked();
    void on_pbSettings_clicked();
    void on_pbAdd_clicked();
    void on_pbRefresh_clicked();

public slots:
    void updateLabel(QString, QString);
    void updateDownloadList(QMap<QString,QMap<QString,QString > > );
    void updateHistoryList(QMap<QString,QMap<QString,QString > > );
    void showError(QString);
};

#endif // MAINWINDOW_H

