#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice
import time

class IsPrimeGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties        
        self.step = 0
        # Universal Properties
        self.task = "The number is prime"
        
    def play(self):
        if self.step == 0:
            self.step = 80
            self.reactor.clearPlayArea()
            self.number = choice(range(2,100))
            self.reactor.drawMainText(str(self.number) + " is prime")
        else:
            self.step = self.step - 1
    
    def is_prime(self, n):
        '''check if integer n is a prime'''
        for x in range(2, int(n**0.5)+1):
            if n % x == 0:
                return False
            return True
    
    def evaluate(self, player):
        if self.is_prime(self.number):
            self.winMessage = "You're right!"
            self.loseMessage = str(self.number) + " is prime!"
            if player == 1: return 1
            if player == 2: return 2
        else:
            self.winMessage = "You win!"
            self.loseMessage = str(self.number) + " is not prime!"
            if player == 1: return 2
            if player == 2: return 1
