#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice
import time

class ColorGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties        
        self.colors = [[(255,0,0), "Red"],
                      [(0,255,0), "Green"],
                      [(0,0,255), "Blue"],
                      [(255,255,0), "Yellow"],
                      [(0,255,255), "Cyan"],
                      [(255,0,255), "Pink"],
                      [(160,0,255), "Purple"],
                      [(255,165,0), "Orange"],
                      [(150,75,0), "Brown"]]
        self.targetColor = choice(self.colors)
        self.step = 0
        self.colorArea = Rect(190, 40,
                              self.reactor.screen.get_width()-380,
                              self.reactor.screen.get_height()-80)
        # Universal Properties
        self.task = "The background is " + self.targetColor[1]
    
    def play(self):
        if self.step == 0:
            self.step = 45
            self.reactor.clearPlayArea()
            choices = []
            for i in range(0,2):
                choices.append(choice(self.colors)[0])
            choices.append(self.targetColor[0])
            self.currentColor = choice(choices)
            pygame.draw.rect(self.reactor.screen, self.currentColor,
                             self.colorArea)
            colorcolor = choice(self.colors)[0]
            while colorcolor == self.currentColor:
                colorcolor = choice(self.colors)[0]
            colorname = choice(self.colors)[1]
            
            self.reactor.drawMainText(colorname, colorcolor)
        else:
            self.step = self.step - 1
    
    def evaluate(self, player):
        if not self.targetColor[0] == self.currentColor:
            self.winMessage = "You win!"
            self.loseMessage = "That's not " + self.targetColor[1] +"!"
            if player == 1: return 2
            if player == 2: return 1
        else:
            self.winMessage = "You win!"
            self.loseMessage = "Too slow!"
            if player == 1: return 1
            if player == 2: return 2
