#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice
import time

class CalcGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties        
        self.step = 0
        #~ self.negative = False
        self.initial = True
        self.numbers = range(-20,20)
        self.numberWords = {1: "One",
                        2: "Two",
                        3: "Three",
                        4: "Four",
                        5: "Five",
                        6: "Six",
                        7: "Seven",
                        8: "Eight",
                        9: "Nine",
                        10: "Ten",
                        11: "Eleven",
                        12: "Twelve",
                        13: "Thirteen",
                        14: "Fourteen",
                        15: "Fifteen",
                        16: "Sixteen",
                        17: "Seventeen",
                        18: "Eighteen",
                        19: "Nineteen",
                        20: "Twenty"}
        self.operators = ["plus", "minus"]
        self.target = choice(self.numbers)
        self.current = self.target
        while self.current == self.target:
            self.current = choice(self.numbers)
        self.wholeCalc = str(self.target) + " = " + str(self.current)
        # Universal Properties
        self.task = "Hit it as soon as the result is "+str(self.target)
    
    def generateNextNumber(self):
        choices = []
        diff = self.target - self.current
        for i in range(0,4):
            if diff < 0:
                choices.append(choice(range(-15,0)+range(1,5)))
            elif diff > 0:
                choices.append(choice(range(-5,0)+range(1,15)))
            else:
                choices.append(choice(range(-10,0)+range(1,10)))
        if (diff == 0): pool = choices
        else: pool = [diff] + choices
        return choice(pool)
        
    def play(self):
        if self.initial:
            self.reactor.clearPlayArea()
            self.reactor.drawMainText(self.wholeCalc)
            self.initial = False
            self.step = 60
        if self.step == 0:
            self.reactor.clearPlayArea()
            next = self.generateNextNumber()
            self.current = self.current + next
            if next > 0:
                self.wholeCalc = self.wholeCalc + " +" + str(next)
            else:
                self.wholeCalc = self.wholeCalc + " " + str(next)
            self.reactor.drawMainText(self.wholeCalc)
            self.step = 80
        else:
            self.step = self.step - 1
        
    def evaluate(self, player):
        identical = (self.current == self.target)
        if not identical:
            self.winMessage = "You win!"
            self.loseMessage = "Not there yet!"
            if player == 1: return 2
            if player == 2: return 1
        else:
            self.winMessage = "Crunching numbers!"
            self.loseMessage = "Too slow!"
            if player == 1: return 1
            if player == 2: return 2
