/*
 * QvernoteWidget.h
 *
 *  Created on: May 27, 2010
 *      Author: alexr
 */

#ifndef QVERNOTEWIDGET_H_
#define QVERNOTEWIDGET_H_

#include <QtGui/QMainWindow>
#include "QvernoteSettings.h"
#include <QMessageBox>

#ifdef Q_WS_MAEMO_5
#include <QMaemo5InformationBox>
#endif

class QvernoteWidget : public QMainWindow
{
public:
	QvernoteWidget(QWidget* parent = 0)
	: QMainWindow(parent),m_settings(QvernoteSettings::Instance())
	{
#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5StackedWindow);
	setDisplayOrientation(m_settings->getDisplayOrientation());

	/*
	switch(orientation) {
	case QvernoteSettings::DO_PORTRAIT:
		setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
		break;
	case QvernoteSettings::DO_LANDSCAPE:
		setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
		break;
	case QvernoteSettings::DO_AUTO:
		setAttribute(Qt::WA_Maemo5AutoOrientation, true);
		break;
	}
	*/
#endif
	}

	~QvernoteWidget() {}

	void setProgressIndicator(bool status)
	{
#ifdef Q_WS_MAEMO_5
		setAttribute(Qt::WA_Maemo5ShowProgressIndicator, status);
#endif
	}

	void displayError(const QString& title, const QString& errorString)
	{
#ifdef Q_WS_MAEMO_5
		QMaemo5InformationBox::information(this, title + "<br/>" + errorString, QMaemo5InformationBox::DefaultTimeout);
#else
		QMessageBox::critical(this, title, errorString);
#endif
	}

	void setDisplayOrientation(QvernoteSettings::DisplayOrientation displayOrientation)
	{
#ifdef Q_WS_MAEMO_5
		switch(displayOrientation) {
		case QvernoteSettings::DO_PORTRAIT:
			setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
			break;
		case QvernoteSettings::DO_LANDSCAPE:
			setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
			break;
		case QvernoteSettings::DO_AUTO:
			setAttribute(Qt::WA_Maemo5AutoOrientation, true);
			break;
		}
#endif
	}
private:
	QvernoteSettings* m_settings;
};
#endif /* QVERNOTEWIDGET_H_ */
