/****************************************************************************
 *  imagemessagefactory_p.h
 *
 *  Copyright (c) 2010 by Sidorov Aleksey <sauron@citadelspb.com>
 *
 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*****************************************************************************/

#ifndef IMAGEMESSAGEFACTORY_P_H
#define IMAGEMESSAGEFACTORY_P_H

#include "stanzaextension.h"
#include "imagemessage.h"

namespace jreen {

class ImageMessageFactory : public StanzaExtensionFactory<ImageMessage>
{
public:
	ImageMessageFactory();
	virtual ~ImageMessageFactory();
	QStringList features() const;
	bool canParse(const QStringRef &name, const QStringRef &uri, const QXmlStreamAttributes &attributes);
	void handleStartElement(const QStringRef &name, const QStringRef &uri, const QXmlStreamAttributes &attributes);
	void handleEndElement(const QStringRef &name, const QStringRef &uri);
	void handleCharacterData(const QStringRef &text);
	void serialize(StanzaExtension *extension, QXmlStreamWriter *writer);
	StanzaExtension::Ptr createExtension();
private:
	QByteArray m_data;
};

} // namespace jreen

#endif // IMAGEMESSAGEFACTORY_P_H
