/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include "optionspanel.h"

#include "settings.h"

#include <QPropertyAnimation>
#include <QGraphicsSceneMouseEvent>
#include <QSequentialAnimationGroup>


#define INITIAL_TOP Settings::scaleHeight(820)


OptionsPanel::OptionsPanel(QGraphicsItem *parent)
    : QGraphicsWidget(parent),
      m_isExpanded(false)
{
    setFlag(QGraphicsItem::ItemHasNoContents, true);

    m_list = new OptionsList(this);
    m_list->setY(INITIAL_TOP);

    connect(m_list->contents(), SIGNAL(itemClicked(int)), SIGNAL(itemClicked(int)));
    connect(m_list->contents(), SIGNAL(itemActivated(int)), SIGNAL(itemClicked(int)));
}

bool OptionsPanel::isExpanded() const
{
    return m_isExpanded;
}

void OptionsPanel::setOptions(const QList<QAction *> &options)
{
    m_list->setOptions(options);
}

void OptionsPanel::expand()
{
    if (m_isExpanded)
        return;

    int fy = size().height() - m_list->desiredHeight();

    setVisible(true);
    m_list->setVisible(true);

    QPropertyAnimation *result = new QPropertyAnimation(m_list, "y");
    result->setEndValue(fy);
    result->setEasingCurve(QEasingCurve::OutQuart);
    result->setDuration(500);

    connect(result, SIGNAL(finished()), SLOT(onExpanded()));
    result->start(QAbstractAnimation::DeleteWhenStopped);
}

void OptionsPanel::collapse()
{
    if (!m_isExpanded)
        return;

    int fy = size().height();

    QPropertyAnimation *result = new QPropertyAnimation(m_list, "y");
    result->setEndValue(fy);
    result->setEasingCurve(QEasingCurve::OutQuart);
    result->setDuration(500);

    connect(result, SIGNAL(finished()), SLOT(onCollapsed()));
    result->start(QAbstractAnimation::DeleteWhenStopped);
}

void OptionsPanel::onExpanded()
{
    m_isExpanded = true;
    emit expanded();
    m_list->contents()->setFocus(Qt::TabFocusReason);
}

void OptionsPanel::onCollapsed()
{
    m_list->setVisible(false);
    setVisible(false);

    m_isExpanded = false;
    emit collapsed();
}

void OptionsPanel::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    QGraphicsWidget::mousePressEvent(event);
    collapse();
}
