/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QDomDocument>
#include "yahoolocationresolver.h"


#define APP_ID "BBAQO1DV34H1VbWYtbe6lI6V3K7p3F4nGYi5_YSLGAwbfebMLvXbv497tu0N"
#define LOCID_URL "http://where.yahooapis.com/v1/places.q('%1');start=0;count=1"
#define LOCID_API_PARAM "appid"


YahooLocationResolver::YahooLocationResolver(QObject *parent)
    : LocationResolver(parent)
{

}

QUrl YahooLocationResolver::formatQuery(const QString &query) const
{
    const QString &normalizedQuery =
        QUrl::toPercentEncoding(query.toLatin1());

    QUrl url(QString(LOCID_URL).arg(normalizedQuery));
    url.addQueryItem(LOCID_API_PARAM, APP_ID);

    return url;
}

QString YahooLocationResolver::parseResponse(QIODevice *reply) const
{
    QDomDocument doc;

    if (!doc.setContent(reply))
        return QString();

    const QDomNodeList &nodeList = doc.elementsByTagName("place");

    const int count = nodeList.count();
    for (int i = 0; i < count; i++) {
        const QDomElement &element = nodeList.at(i).firstChildElement("woeid");
        return element.isNull() ? QString() : element.text();
    }

    return QString();
}
