/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef CITYLIST_H
#define CITYLIST_H

#include <QGraphicsItem>

#include "contentlist.h"
#include "forecastdata.h"

#include <ImtkLabel>
#include <ImtkButton>
#include <ImtkScrollBar>
#include <ImtkScrollArea>


// CityListItem

class CityContentList;

class CityListItem : public ContentListItem
{
    Q_OBJECT
    Q_PROPERTY(qreal opacity READ opacity WRITE setOpacity);
public:
    CityListItem(const ForecastData &data, CityContentList *list, bool deleteVisible);
    void select(bool selected);

    const ForecastData &data() const { return m_data; }

    qreal contentHeight() const;

    QAbstractAnimation *showAnimation();
    QAbstractAnimation *hideAnimation();
    QAbstractAnimation *buttonAnimation(bool hide);

protected:
    void stateChanged(ContentListItem::State state);
    void mousePressEvent(QGraphicsSceneMouseEvent *ev);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *ev);

private slots:
    void removeFromList();

private:
    const qreal m_height;
    const ForecastData m_data;
    CityContentList * const m_list;

    QGraphicsPixmapItem * const m_background;
    QGraphicsPixmapItem * const m_check;
    ImtkButton *m_delete;
    ImtkLabel *m_text;

    template<class T> static QAbstractAnimation *getFadeAnimation(T *target, bool hide, int msecs);

private slots:
    void doHide() { hide(); }

};

// CityContentList

class CityContentList : public ContentList
{
    Q_OBJECT
    Q_PROPERTY(qreal top READ getTop WRITE setTop);
public:
    CityContentList(QObject *holder);

    void select(const QString &selected);

protected:
    QAbstractAnimation *insertAnimation(int idx, qreal height);
    QAbstractAnimation *removeAnimation(int idx);

protected slots:
     void addForecast(const ForecastData &data);

private:
    QObject * const m_holder;

    QAbstractAnimation *createCompoundAnimation(QList<QAbstractAnimation*> list);
    QAbstractAnimation *getItemMoveAnimation(int idx, qreal offset);
    QAbstractAnimation *getMoveAnimation(QObject *object, qreal offset);

    qreal getTop() { return pos().y(); }
    void setTop(qreal top) { setPos(pos().x(), top); }
};

// CityList

class CityList : public QGraphicsWidget
{
    Q_OBJECT
    Q_PROPERTY(qreal top READ getTop WRITE setTop);

public:
    CityList(QGraphicsItem *parent = 0);

    void select(const QString &selected) { m_list->select(selected); }

    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget = 0);

    QGraphicsWidget *scroll() const;
    CityContentList *contents() const;

    static int loadImages();

    qreal initialTop() const;

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

protected slots:
    void updateScrollBar();

private:
    const QPixmap m_panelTop;
    const qreal m_itemHeight;

    CityContentList * const m_list;
    ImtkScrollBar *m_scroll;
    ImtkScrollArea *m_scrollBox;

    qreal getTop() { return pos().y(); }
    void setTop(qreal top) { setPos(pos().x(), top); }
};

#endif
