#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QDBusConnection>
#include "dialogpreferences.h"


// TODO calculate freq depending on time thinking
// TODO reset statistics
// TODO get top failures
// TODO animations??
// TODO autorotation with screen

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
	showImage = false;

	menuBar()->clear();
	menuBar()->addAction(tr("About"), this, SLOT(about()));
	menuBar()->addAction(tr("Donate"), this, SLOT(donate()));
	menuBar()->addAction(tr("Options"), this, SLOT(options()));
	menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));

    //timer = NULL;

    QCoreApplication::setOrganizationName("nowheremanmail");
    QCoreApplication::setOrganizationDomain("gmail.com");
    QCoreApplication::setApplicationName("qtCalculus");

    ui->setupUi(this);

    //ui->centralWidget->setLayout(new QHBoxLayout);

    animTimer = 0;
    tickTimer = 0;

    currentItem = NULL;
    numbers = new RandomNumbers;

    think ();

	QDBusConnection conn = QDBusConnection::systemBus(); //QString(MCE_SERVICE), QString(MCE_SIGNAL_PATH)
	bool success = conn.connect("","", QString("com.nokia.mce.signal"/*MCE_SIGNAL_IF*/), QString("display_status_ind"/*MCE_DISPLAY_SIG*/) , this, SLOT(listenInactivity(QString)));

}

void MainWindow::listenInactivity(QString s) {
	////qDebug () << "HELLO " << s;
	if (s == QString("off")) {
		if (animTimer != 0)
			this->killTimer(animTimer);
	    if (tickTimer != 0)
	    	this->killTimer(tickTimer);
	}
	else {
		if (s == QString("on")) {
			think ();
		}
	}
}

void MainWindow::about()
{
    QMessageBox::about(this, tr("About Calculus"), tr("<qt><br><br><p><i><b>qtCalculus</b></i>, v.%1</p>"\
			"<p>Developed by <b>nowheremanmail@gmail.com</b></p>"\
			"<p>if you think that qtCalculus is useful for you, please</p>"\
			"<a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=nowheremanmail@gmail.com&lc=US&item_name=qtcalculus&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted\">DONATE</a></qt>").arg(VERSION));
}
void MainWindow::donate() {
	QDesktopServices::openUrl( QUrl::fromEncoded("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=nowheremanmail@gmail.com&lc=US&item_name=qtcalculus&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted" ) );
}

void MainWindow::options () {
    DialogPreferences * d = new DialogPreferences;
    d->exec();

    numbers->prepare (true);
    think ();

    delete d;
}

void MainWindow::fail(int t) {
	fails++;
    anim = 10;
    wasOk = false;
    showImage = true;
   	animTimer = this->startTimer(55);
}

void MainWindow::ok() {
    anim = 10;
    showImage = true;
    wasOk = true;
   	animTimer = this->startTimer(55);
}

void MainWindow::onTick() {
    ticks++;
}

void MainWindow::timerEvent(QTimerEvent *event) {
	if (tickTimer == event->timerId()) {
            ticks++;

            QFont font;
            font.setPointSize( (ticks % 40) + 36);
            ui->operation->setFont(font);
            ui->label_1_1->setFont(font);
            ui->label_1_0->setFont(font);
            ui->label_0_1->setFont(font);
            ui->label_0_0->setFont(font);
            ui->result1->setFont(font);
            ui->result0->setFont(font);

            return;
	}

	if (animTimer != event->timerId())
		return;

	if (anim <= 0) {
		this->killTimer(animTimer);
		//animTimer = 0;
	    showImage = false;
		anim = 0;
		if (wasOk) {
			numbers->update(currentItem, 0, ticks);
		}
		else {
			numbers->update(currentItem, 1, ticks);
		}

	} else {
		anim--;
	}

	update();
}

void MainWindow::paintEvent ( QPaintEvent * event ) {
	//qDebug () << "paing " << event;

	QMainWindow::paintEvent(event);

	if (showImage) {
		QPainter painter(this);
		QPen pen = painter.pen();
		painter.setPen(pen);
		painter.setOpacity((double)anim / 10.0);

		if (wasOk) {
			QPixmap image(":/resources/good.png");
			painter.drawPixmap (0,0, image);
		}
		else {
			QPixmap image(":/resources/bad.png");
			painter.drawPixmap (0,0, image);
		}
	}
//	if (hasFocus()) {
//		QRect r = rect();
////		int ad = anim - 5;
////		r.adjust(ad, ad, ad, ad);
////		r.setTopLeft(QPoint(anim * -1, anim * -1));
//
//#if defined (Q_OS_SYMBIAN)
//		QBrush b(Qt::white, Qt::SolidPattern);
//#else
//		QBrush b(Qt::blue,Qt::SolidPattern);
//#endif
//
//		painter.setBrush(b);
//		painter.setPen(Qt::black);
//		QPen pen = painter.pen();
////		if (animTimer != 0) {
////			pen.setWidth(3);
////			painter.setPen(pen);
////			painter.setOpacity(0.4);
////		} else {
//			pen.setWidth(1);
//			painter.setPen(pen);
//			painter.setOpacity(0.2);
//		//}
//
//		painter.drawRoundedRect(r, 5, 5);
//	}
}

void MainWindow::think () {
	fails = 0;
    ticks = 0;
    if (tickTimer != 0)
    	this->killTimer(tickTimer);

//    if (timer == NULL) {
//        timer = new QTimer(this);
//        timer->start(1000);
//    }
//    else {
//        timer->stop();
//        timer->start(1000);
//    }
//
//    QObject::connect(timer,SIGNAL(timeout()),this,SLOT(onTick()));

    current = "";

    currentItem = numbers->next();

    operation = currentItem->operation;
    mode = currentItem->mode;

    switch (mode) {
    case 1:
        number1 = -1;
        number0 = currentItem->num0;
        result = currentItem->result;
        break;
    case 0:
        number1 = currentItem->num1;
        number0 = -1;
        result = currentItem->result;
        break;
    case 2:
        number1 = currentItem->num1;
        number0 = currentItem->num0;
        result = -1;
        break;
    }

    show1 (number1);
    show0 (number0);
    showResult (result);
    showOperation (operation);

    // TODO fail = 0, time = 0
    tickTimer = this->startTimer(500);
}

void MainWindow::showOperation(int n) {
    switch (n) {
    case PRODUCT:
        ui->operation->setText("x");
        break;
    case SUM:
        ui->operation->setText("+");
        break;
    case MINUS:
        ui->operation->setText("-");
        break;
    }
}

void MainWindow::show1(int n) {
    if (n < 0) {
        ui->label_1_1->setText(" ");
        ui->label_1_0->setText("?");
    }
    else {
        ui->label_1_1->setText(QString (" 123456789").at(n / 10));
        ui->label_1_0->setText(QString ("0123456789").at(n % 10));
    }
}
void MainWindow::show0(int n) {
    if (n < 0) {
        ui->label_0_1->setText(" ");
        ui->label_0_0->setText("?");
    }
    else {
        ui->label_0_1->setText(QString (" 123456789").at(n / 10));
        ui->label_0_0->setText(QString ("0123456789").at(n % 10));
    }
}
void MainWindow::showResult(int n) {
    if (n < 0) {
        ui->result1->setText(" ");
        ui->result0->setText("?");
    }
    else {
        ui->result1->setText(QString (" 123456789").at(n / 10));
        ui->result0->setText(QString ("0123456789").at(n % 10));
    }
}

MainWindow::~MainWindow()
{
    delete ui;
}
void MainWindow::set(char c) {
    if (current.length() < 2) {
        current = current + c;
    }
    else {
        fail (1);
    }

    int tmp = current.toInt();

    switch (mode) {
    case 1:
        number1 = tmp;
        show1(number1);
        break;
    case 0:
        number0 = tmp;
        show0(number0);
        break;
    case 2:
        result = tmp;
        showResult(result);
        break;
    }
}
void MainWindow::on_pushButtonOK_clicked()
{
    confirm ();
}
void MainWindow::confirm() {
    bool isOk = false;

    switch (operation) {
    case PRODUCT: // x
        isOk = (number1 * number0) == result;
        break;
    case SUM: // +
        isOk = (number1 + number0) == result;
        break;
    case MINUS: // -
        isOk = (number1 - number0) == result;
        break;
    }


    if (isOk) {
        ok ();
        think ();
    }
    else {
        fail (0);
        clear ();
    }
}
void MainWindow::clear() {
    current = "";
    switch (mode) {
    case 1:
        number1 = -1;
        show1(number1);
        break;
    case 0:
        number0 = -1;
        show0(number0);
        break;
    case 2:
        result = -1;
        showResult(result);
        break;
    }
}
void MainWindow::on_pushButtonCL_clicked()
{
    clear ();
}

void MainWindow::on_pushButton0_clicked()
{
    set('0');
}
void MainWindow::on_pushButton1_clicked()
{
    set('1');
}
void MainWindow::on_pushButton2_clicked()
{
    set('2');
}
void MainWindow::on_pushButton3_clicked()
{
    set('3');
}
void MainWindow::on_pushButton4_clicked()
{
    set('4');
}
void MainWindow::on_pushButton5_clicked()
{
    set('5');
}
void MainWindow::on_pushButton6_clicked()
{
    set('6');
}
void MainWindow::on_pushButton7_clicked()
{
    set('7');
}
void MainWindow::on_pushButton8_clicked()
{
    set('8');
}
void MainWindow::on_pushButton9_clicked()
{
    set('9');
}




