/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedBoolean.h"

#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAnimatedBoolean);

/* Hash table */

static const HashTableValue JSSVGAnimatedBooleanTableValues[4] =
{
    { "baseVal", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedBooleanBaseVal), (intptr_t)setJSSVGAnimatedBooleanBaseVal },
    { "animVal", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedBooleanAnimVal), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedBooleanConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedBooleanTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSSVGAnimatedBooleanTableValues, 0 };
#else
    { 8, 7, JSSVGAnimatedBooleanTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGAnimatedBooleanConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedBooleanConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGAnimatedBooleanConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGAnimatedBooleanConstructorTableValues, 0 };
#endif

class JSSVGAnimatedBooleanConstructor : public DOMConstructorObject {
public:
    JSSVGAnimatedBooleanConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGAnimatedBooleanConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGAnimatedBooleanPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGAnimatedBooleanConstructor::s_info = { "SVGAnimatedBooleanConstructor", 0, &JSSVGAnimatedBooleanConstructorTable, 0 };

bool JSSVGAnimatedBooleanConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedBooleanConstructor, DOMObject>(exec, &JSSVGAnimatedBooleanConstructorTable, this, propertyName, slot);
}

bool JSSVGAnimatedBooleanConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedBooleanConstructor, DOMObject>(exec, &JSSVGAnimatedBooleanConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedBooleanPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedBooleanPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGAnimatedBooleanPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGAnimatedBooleanPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGAnimatedBooleanPrototype::s_info = { "SVGAnimatedBooleanPrototype", 0, &JSSVGAnimatedBooleanPrototypeTable, 0 };

JSObject* JSSVGAnimatedBooleanPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedBoolean>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedBoolean::s_info = { "SVGAnimatedBoolean", 0, &JSSVGAnimatedBooleanTable, 0 };

JSSVGAnimatedBoolean::JSSVGAnimatedBoolean(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedBoolean> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGAnimatedBoolean::~JSSVGAnimatedBoolean()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGAnimatedBoolean::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGAnimatedBooleanPrototype(JSSVGAnimatedBooleanPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGAnimatedBoolean::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedBoolean, Base>(exec, &JSSVGAnimatedBooleanTable, this, propertyName, slot);
}

bool JSSVGAnimatedBoolean::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedBoolean, Base>(exec, &JSSVGAnimatedBooleanTable, this, propertyName, descriptor);
}

JSValue jsSVGAnimatedBooleanBaseVal(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGAnimatedBoolean* castedThis = static_cast<JSSVGAnimatedBoolean*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedBoolean* imp = static_cast<SVGAnimatedBoolean*>(castedThis->impl());
    JSValue result = jsBoolean(imp->baseVal());
    return result;
}

JSValue jsSVGAnimatedBooleanAnimVal(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGAnimatedBoolean* castedThis = static_cast<JSSVGAnimatedBoolean*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedBoolean* imp = static_cast<SVGAnimatedBoolean*>(castedThis->impl());
    JSValue result = jsBoolean(imp->animVal());
    return result;
}

JSValue jsSVGAnimatedBooleanConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGAnimatedBoolean* domObject = static_cast<JSSVGAnimatedBoolean*>(asObject(slotBase));
    return JSSVGAnimatedBoolean::getConstructor(exec, domObject->globalObject());
}
void JSSVGAnimatedBoolean::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGAnimatedBoolean, Base>(exec, propertyName, value, &JSSVGAnimatedBooleanTable, this, slot);
}

void setJSSVGAnimatedBooleanBaseVal(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGAnimatedBoolean* castedThisObj = static_cast<JSSVGAnimatedBoolean*>(thisObject);
    SVGAnimatedBoolean* imp = static_cast<SVGAnimatedBoolean*>(castedThisObj->impl());
    imp->setBaseVal(value.toBoolean(exec));
    JSSVGContextCache::propagateSVGDOMChange(castedThisObj, imp->associatedAttributeName());
}

JSValue JSSVGAnimatedBoolean::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedBooleanConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedBoolean* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGAnimatedBoolean>(exec, globalObject, object, context);
}
SVGAnimatedBoolean* toSVGAnimatedBoolean(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedBoolean::s_info) ? static_cast<JSSVGAnimatedBoolean*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
