#include "logindialog.h"

LoginDialog::LoginDialog(QSettings* pSettings, QWidget *parent)
    : QDialog(parent)
{
    //construct login dialog UI
    m_pAppSettings = pSettings;

    //setup signal / slot connections
    connect(&m_LoginBtn,SIGNAL(clicked()),SLOT(OnLogin()));
    //connect(QApplication::desktop(), SIGNAL(resized(int)),SLOT(OnOrientationChanged()));

    setWindowTitle(tr("QSpot - Login"));

    //set up UI elements
    m_UserIDText.setText(tr("UserID:"));
    m_UserIDInput.setInputMethodHints(Qt::ImhNoAutoUppercase); //no auto-uppercase mode
    m_PasswordText.setText(tr("Password:"));
    m_PasswordInput.setEchoMode(QLineEdit::Password);

    m_LoginBtn.setText(tr("Login"));

    if(m_pAppSettings)
    {
        //read save credentials state from the app settings file
        int saveCredentials = m_pAppSettings->value("QSpot/SaveCredentials",0).toInt();
        if(saveCredentials)
        { //restore saved credentials (UserID and password) from settings file
            m_UserIDInput.setText(m_pAppSettings->value("QSpot/UserID","").toString());
            m_PasswordInput.setText(m_pAppSettings->value("QSpot/Password","").toString());
        }
    }

    m_Layout.addWidget(&m_UserIDText,0,0);
    m_Layout.addWidget(&m_UserIDInput,0,1);
    m_Layout.addWidget(&m_PasswordText,1,0);
    m_Layout.addWidget(&m_PasswordInput,1,1);
    m_Layout.addWidget(&m_LoginBtn,2,1);
    m_Layout.setRowStretch(1,1);
    m_Layout.setRowStretch(2,50);

    setLayout(&m_Layout);
}

LoginDialog::~LoginDialog()
{
}


void LoginDialog::OnLogin()
{
    //request to login to Spotify
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator,true); //display progress indicator
#endif
    m_LoginBtn.setDisabled(true);
    emit doSpotifyLogin(m_UserIDInput.text(),m_PasswordInput.text());
}


void LoginDialog::resetState()
{
        //reset state after e.g., login
#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5ShowProgressIndicator,false); //hide progress indicator
#endif
	m_LoginBtn.setDisabled(false);
        //m_UserIDInput.setText("");
	m_UserIDInput.setCursorPosition(0);
        //m_PasswordInput.setText("");
	m_PasswordInput.setCursorPosition(0);
	m_UserIDInput.setFocus();
}

void LoginDialog::OnOrientationChanged()
{
    //device orientation changed (e.g, screen rotate)

  /*  QRect screenGeometry = QApplication::desktop()->screenGeometry(); // get current screen geometry
    if (screenGeometry.width() > screenGeometry.height())
    {
        //switch to landscape mode
    }
    else
    {
        //switch to portrait mode
    }

    */
}

