//MCEWrapper.h: Header for the MCE D-bus wrapper class (MCE manages e.g., display backlight state)

#ifndef MCEWRAPPER_H
#define MCEWRAPPER_H

#include <QObject>
#include <QDBusConnection>
#include <QDBusInterface>
#include <mce/dbus-names.h>
#include <mce/mode-names.h>

class MCEWrapper : public QObject
{
    Q_OBJECT

public:

    MCEWrapper(QObject *parent = 0); //constructor
    ~MCEWrapper(); //destructor


private slots:

    void setDisplayState(const QString &state);
    void displayStateChanged(const QDBusMessage &message);
    void displayStateError(const QDBusError &error);

signals:

    void onDisplayStateChange(bool); //display state change signal (true=ON, false=OFF).

};

#endif // MCEWRAPPER_H
