#include "emittingbutton.h"
#include <QProcess>
#include <QTimer>

EmittingButton::EmittingButton(QWidget *parent=0 , double db=0, int indx=0) : QPushButton(parent)
{
    timer = new QTimer;
    index=indx;
    freq=db;
    this->setText(QString::number(db, 'f', 1));
    connect(this, SIGNAL(pressed()), SLOT(buttonIsClicked()));
    connect(this, SIGNAL(released()), SLOT(buttonReleased()));
    connect(timer, SIGNAL(timeout()), this, SLOT(timeout()));

}

void EmittingButton::buttonIsClicked()
{
    timer->start(1000);

}

void EmittingButton::buttonReleased()
{
    if (timer->isActive())
    {
        timer->stop();

        int n = this->text().toDouble()*1000000;

        emit buttonClicked(n);;
    }
    else

    {

        timer->stop();
    }
}

void EmittingButton::timeout()
{
    emit buttonIsHold(index);
    timer->stop();
}


