#include "kalpineloop.h"
#include "ui_kalpineloop.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

KalpineLoop::KalpineLoop(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::KalpineLoop)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("Alpine Butterfly Loop"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set Image
    imgScene = new QGraphicsScene(ui->img);
    QGraphicsPixmapItem *item;
    QPixmap mImg("/opt/qnotted/images/kalpineloop.jpg");
    ui->img->setScene(imgScene);
    mImg = mImg.scaled(QSize(180, 180), Qt::KeepAspectRatio);
    item = new QGraphicsPixmapItem(mImg);
    imgScene->addItem(item);

    //Set Large Image
    imgSceneLarge = new QGraphicsScene(ui->imgLarge);
    QGraphicsPixmapItem *itemLarge;
    QPixmap mImgLarge("/opt/qnotted/images/kalpineloop.jpg");
    ui->imgLarge->setScene(imgSceneLarge);
    mImgLarge = mImgLarge.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemLarge = new QGraphicsPixmapItem(mImgLarge);
    imgSceneLarge->addItem(itemLarge);

    //Button Text
    ui->pushButton_Up->setText("");
    ui->pushButton_Down->setText("");
    ui->pushButton_Reset->setText("");


    // Set Button Icons
    ui->pushButton_Up->setIcon(QPixmap("/opt/qnotted/icons/br_up_icon&48.png"));
    ui->pushButton_Down->setIcon(QPixmap("/opt/qnotted/icons/br_down_icon&48.png"));
    ui->pushButton_Reset->setIcon(QPixmap("/opt/qnotted/icons/dash.png"));

    //Hide On Draw
    ui->pushButton_Reset->hide();
    ui->imgLarge->hide();

    //Set Text
    ui->textBrowser->setText(tr("\
        <b><u>Alpine Butterfly Loop</u></b> <br> \
        Take a bight in the rope and form an elbow. <br> \
        Spread apart the twist in the rope to make an '8' shape, the rope should cross itself twice, with the standing ends towards you. <br> \
        Take hold of the top of the '8' shape, pass this over the '8' shape, between the standing ends and up through the bottom part of the '8' shape. <br> \
        Pull away on the bight you have made and the standing ends to tighten the interlocked overhand knots. <br> \
        Then finally pull the standing ends apart and dress the knot into it's recognisable form. <br> \
        <br> \
        <b>Important</b> <br> \
        Follow these steps carefully, this knot can be tied incorrectly forming an 'imposter knot' that looks similar but is far less secure. <br> \
                                "));

    // For Connecting Keyboard Buttons
              connectSignals();
}

KalpineLoop::~KalpineLoop()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void KalpineLoop::connectSignals()
{

// Keyboard Key Signals

        connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
     connect(new QShortcut(QKeySequence(Qt::Key_Up), this), SIGNAL(activated()), this, SLOT(on_pushButton_Up_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Down), this), SIGNAL(activated()), this, SLOT(on_pushButton_Down_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Space), this), SIGNAL(activated()), this, SLOT(on_pushButton_Reset_pressed()));
}

// End of Keyboard Signals


//Push Buttons

void KalpineLoop::on_pushButton_Up_pressed()
{
    ui->img->hide();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->hide();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->show();
}

void KalpineLoop::on_pushButton_Reset_pressed()
{
    ui->img->show();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->show();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->hide();
}

void KalpineLoop::on_pushButton_Down_pressed()
{
    ui->img->hide();
    ui->imgLarge->show();
    ui->textBrowser->hide();
    ui->pushButton_Up->show();
    ui->pushButton_Down->hide();
    ui->pushButton_Reset->show();
}
