#!/usr/bin/env python
#-*- coding: utf-8 -*-

import sqlite3
import time
import myconfig

class MyDB:
	def __init__(self, filedb = myconfig.file_db):
		self.mydb = sqlite3.connect(filedb)
		self.mydb.isolation_level = None #autocommit
		self.cur = self.mydb.cursor()
		self.createDB()


	def __del__(self):
		try:
			self.mydb.close()
		except Exception, E:
			print "MyDB::__del__(): %s\n"%E


	def createDB(self):
		sql_pragma = "PRAGMA foreign_keys = ON;"

		sql_create_alliface  = "CREATE TABLE IF NOT EXISTS 'main'.'alliface' ( "
		sql_create_alliface += "'id' INTEGER UNIQUE PRIMARY KEY NOT NULL, "
		sql_create_alliface += "'iface' TEXT NOT NULL);"

		sql_create_type  = "CREATE TABLE IF NOT EXISTS 'main'.'type' ( "
		sql_create_type += "'id' INTEGER UNIQUE PRIMARY KEY NOT NULL, "
		sql_create_type += "'iface' TEXT NOT NULL, "
		sql_create_type += "'auto_rec' INTEGER DEFAULT 0);"

		sql_create_session  = "CREATE TABLE IF NOT EXISTS 'main'.'session' ( "
		sql_create_session += "'id' INTEGER UNIQUE PRIMARY KEY AUTOINCREMENT NOT NULL, "
		sql_create_session += "'start' DATETIME, "
		sql_create_session += "'stop' DATETIME, "
		sql_create_session += "'type_id' INTEGER REFERENCES 'type' ('id') ON DELETE CASCADE ON UPDATE CASCADE );"
		
		sql_create_traf  = "CREATE TABLE IF NOT EXISTS 'main'.'traff' ( "
		sql_create_traf += "'id' INTEGER UNIQUE PRIMARY KEY AUTOINCREMENT NOT NULL, "
		sql_create_traf += "'timestamp' DATETIME DEFAULT CURRENT_TIMESTAMP, "
		sql_create_traf += "'rx' TEXT, "
		sql_create_traf += "'tx' TEXT,"
		sql_create_traf += "'type_id' INTEGER REFERENCES 'type' ('id') ON DELETE CASCADE ON UPDATE CASCADE );"

		sql_create_options  = "CREATE TABLE IF NOT EXISTS 'main'.'options' ( "
		sql_create_options += "'color_rx' TEXT, "
		sql_create_options += "'color_tx' TEXT, "
		sql_create_options += "'date_format_view' TEXT, "
		sql_create_options += "'freq_traff_daemon' TEXT, "
		sql_create_options += "'limit_size_db' TEXT"
		sql_create_options += ");"

		sql_alliface_gprs = "INSERT INTO 'main'.'alliface' (id, iface) VALUES (1, 'gprs0')"
		sql_alliface_wlan = "INSERT INTO 'main'.'alliface' (id, iface) VALUES (2, 'wlan0')"
		sql_alliface_usb =  "INSERT INTO 'main'.'alliface' (id, iface) VALUES (3, 'usb0')"
		sql_alliface_pan =  "INSERT INTO 'main'.'alliface' (id, iface) VALUES (4, 'pan0')"
		sql_alliface_eth =  "INSERT INTO 'main'.'alliface' (id, iface) VALUES (5, 'eth0')"
		try:
			R = self.cur.execute(sql_pragma)
		except Exception, E:
			pass
			#print "MyDB::createDB(): %s\n"%E
		
		try:
			R = self.cur.execute(sql_create_type)
		except Exception, E:
			print "MyDB::createDB(): [%s] %s\n"%(sql_create_type, E)

		try:
			R = self.cur.execute(sql_create_session)
		except Exception, E:
			print "MyDB::createDB(): [%s] %s\n"%(sql_create_session, E)

		try:
			R = self.cur.execute(sql_create_traf)
		except Exception, E:
			print "MyDB::createDB(): [%s] %s\n"%(sql_create_traf, E)

		try:
			R = self.cur.execute(sql_create_options)
		except Exception, E:
			print "MyDB::createDB(): [%s] %s\n"%(sql_create_options, E)
		
		#--- alliface ---#
		try:
			R = self.cur.execute(sql_create_alliface)
		except Exception, E:
			pass
		try:
			R = self.cur.execute(sql_alliface_gprs)
		except Exception, E:
			pass
		try:
			R = self.cur.execute(sql_alliface_wlan)
		except Exception, E:
			pass
		try:
			R = self.cur.execute(sql_alliface_usb)
		except Exception, E:
			pass
		try:
			R = self.cur.execute(sql_alliface_pan)
		except Exception, E:
			pass
		try:
			R = self.cur.execute(sql_alliface_eth)
		except Exception, E:
			pass
		#----------------#
		


	def writeTraff(self, rx, tx, type, time_stamp = 0):
		if ( rx != 0 ) and ( tx != 0 ):
			if time_stamp != 0:
				d = (time_stamp,rx,tx,type)
				sql_wrt = "INSERT INTO 'main'.'traff' (timestamp, rx, tx, type_id) VALUES (?, ?, ?, ?);"
			else:
				d = (rx,tx,type)
				sql_wrt = "INSERT INTO 'main'.'traff' (rx, tx, type_id) VALUES (?, ?, ?);"

			try:
				R = self.cur.execute(sql_wrt,d)
			except Exception, E:
				print "MyDB::writeTraff(): Query error: %s"%E


	def startSession(self, type):
		startTime = time.localtime( time.time() )
		strStartTime = time.strftime( "%Y-%m-%d %H:%M:%S", startTime )
		retVal = strStartTime

		k = (strStartTime, type)
		sql = "INSERT INTO 'main'.'session' (start,type_id) VALUES (?, ?);"
	
		try:
			self.cur.execute(sql,k)
		except Exception, E:
			print "MyDB::startSession(): %s\n"%E
			retVal = None

		return retVal


	def stopSession(self, startTime, type):
		stopTime = time.localtime( time.time() )
		strStopTime = time.strftime( "%Y-%m-%d %H:%M:%S", stopTime )
		retVal = strStopTime

		sql = "UPDATE 'main'.'session' SET stop='%s' WHERE type_id == %s AND start == '%s';"%(strStopTime,type,startTime)
	
		try:
			self.cur.execute(sql)
		except Exception, E:
			print "MyDB::stopSession(): %s\n"%E
			retVal = None

		return retVal


	#---- alliface ----#
	def getIfaceByType(self,type_id):
		retVal = None
		#sql = "SELECT iface FROM 'main'.'type' WHERE id == %s;"%(type_id)
		sql = "SELECT iface FROM 'main'.'alliface' WHERE id == %s;"%(type_id)
		try:
			self.cur.execute(sql)
			retVal = self.cur.fetchone()[0]
		except Exception, E:
			print "MyDB::getIfaceByType(): %s\n"%E
			retVal = None
		return retVal


	def getTypeByIface(self,iface):
		retVal = None
		#sql = "SELECT id FROM 'main'.'type' WHERE iface == '%s';"%(iface)
		sql = "SELECT id FROM 'main'.'alliface' WHERE iface == '%s';"%(iface)
		try:
			self.cur.execute(sql)
			retVal = self.cur.fetchone()[0]
		except Exception, E:
			print "MyDB::getTypeByIface(): [%s] %s\n"%(sql, E)
			retVal = None
		return retVal
	
	#возвращает полный 'список' сетевых интерфейсов
	def getBuffIface(self):
		SQL = "SELECT * FROM 'main'.'alliface'"
		bufReturn = {}
		try:
			j = 0
			for row in self.cur.execute( SQL ):
				type = row[0]
				iface = row[1]
				bufReturn[ type ] = iface
		except Exception, E:
			print "MyDB::getBuffIface(): [%s] %s\n"%(SQL, E)
		return bufReturn
	#--------#


	# возвращает список сессий за указанный период времени и типу трафика
	def getListSession(self, type_session, start_time=None, end_time=None):
		if start_time != None and end_time != None:
			SQL = "select `start`,`stop`,`type_id` FROM 'main'.'session' WHERE stop NOT NULL AND type_id=%s AND start > '%s' AND stop < '%s'"%( type_session, start_time, end_time )
		elif start_time != None and end_time == None:
			SQL = "select `start`,`stop`,`type_id` FROM 'main'.'session' WHERE stop NOT NULL AND type_id=%s AND start > '%s'"%( type_session, start_time )
		elif start_time == None and end_time != None:
			SQL = "select `start`,`stop`,`type_id` FROM 'main'.'session' WHERE stop NOT NULL AND type_id=%s AND stop < '%s'"%( type_session, end_time )
		else:
			SQL = "select `start`,`stop`,`type_id` FROM 'main'.'session' WHERE stop NOT NULL AND type_id=%s"%type_session
		
		listReturn = []
		try:
			j = 0
			for row in self.cur.execute( SQL ):
				session = {}
				session["start"] = row[0]
				session["stop"] = row[1]
				session["type_session"] = row[2]
				listReturn.append(session)
				j += 1
		except Exception, E:
			print "MyDB::getListSession(): %s\n"%E

		return listReturn
	
	
	# возвращает список сессий за указанный период времени без типа трафика
	def getFullListSession(self, start_time=None, end_time=None):
		if start_time != None and end_time != None:
			SQL = "select `start`,`stop`,`type_id` FROM 'main'.'session' WHERE stop NOT NULL AND start > '%s' AND stop < '%s'"%( start_time, end_time )
		elif start_time != None and end_time == None:
			SQL = "select `start`,`stop`,`type_id` FROM 'main'.'session' WHERE stop NOT NULL AND start > '%s'"%( start_time )
		elif start_time == None and end_time != None:
			SQL = "select `start`,`stop`,`type_id` FROM 'main'.'session' WHERE stop NOT NULL AND stop < '%s'"%( end_time )
		else:
			SQL = "select `start`,`stop`,`type_id` FROM 'main'.'session' WHERE stop NOT NULL"
		
		listReturn = []
		try:
			j = 0
			for row in self.cur.execute( SQL ):
				session = {}
				session["start"] = row[0]
				session["stop"] = row[1]
				session["type_session"] = row[2]
				listReturn.append(session)
				j += 1
		except Exception, E:
			print "MyDB::getFullListSession(): %s\n"%E

		return listReturn

	# возвращает массив (словарь) с трафиком для опреленного временного участка start_time..stop_time и указанного типа трафика
	def getTraffByTime( self, start_time, stop_time, type_session ):
		SQL = "SELECT `timestamp`, `rx`, `tx`, `type_id` from 'main'.'traff' where `timestamp` <= '%s' AND `timestamp` >= '%s' AND type_id == %s"%( stop_time, start_time, type_session )
		
		bufReturn = {}
		try:
			j = 0
			for row in self.cur.execute( SQL ):
				traff = {}
				traff["timestamp"] = row[0]
				traff["rx"] = row[1]
				traff["tx"] = row[2]
				traff["type_session"] = row[3]
				bufReturn[j] = traff
				j += 1
		except Exception, E:
			print SQL
			print "MyDB::getTraffByTime(): %s\n"%E

		return bufReturn

	# очищает БД от записей сессий и трафика за указанный период времени (start_delete_time..stop_delete_time)
	#TODO: прикрутить учет типа трафика
	def cleanDBbyTime(self, start_delete_time, stop_delete_time):
		SQL1 = "DELETE FROM 'main'.'traff' WHERE `timestamp` >= '%s' AND `timestamp` <= '%s'"%(start_delete_time, stop_delete_time)
		SQL2 = "DELETE FROM 'main'.'session' WHERE `start` >= '%s' AND `stop` <= '%s'"%(start_delete_time, stop_delete_time)
		
		ok = True
		try:
			self.cur.execute( SQL1 )
		except Exception, E:
			print SQL1
			print "MyDB::cleanDBbyTime(): %s\n"%E
			ok = False
			return ok
		
		try:
			self.cur.execute( SQL2 )
		except Exception, E:
			print SQL2
			print "MyDB::cleanDBbyTime(): %s\n"%E
			ok = False

		return ok

	# сохраняет цвет графиков в опциях (в БД)
	# color_rx, color_tx - цвета вх. и исх. графиков в виде строки #RRGGBB
	# new - устанавливается значение True если записи в БД до момента вызова функции не существовало.
	def optSetColor(self, color_rx, color_tx, new=False):
		if new:
			SQL = "INSERT INTO 'main'.'options' (color_rx, color_tx) VALUES ('%s', '%s')"%(color_rx,color_tx)
		else:
			SQL = "UPDATE 'main'.'options' SET color_rx='%s', color_tx='%s'"%(color_rx, color_tx)

		ok = True
		try:
			self.cur.execute( SQL )
		except Exception, E:
			print SQL
			print "MyDB::optSetColorRX(): %s\n"%E
			ok = False
		return ok
	
	# 
	#Возвращает цвета графиков (кортеж) в виде строки, записанной как #RRGGBB
	def optGetColor(self):
		SQL = "SELECT color_rx, color_tx FROM 'main'.'options'"
		new = True
		try:
			self.cur.execute(SQL)
			color = self.cur.fetchone()
			color_rx = color[0]
			color_tx = color[1]
			if (color_rx == None) or (color_tx == None):
				new = False
				raise Exception("Colors are not define. Set default")
		except Exception, E:
			print "MyDB::optGetColor(): %s\n"%E
			color_rx = '#14BE64'
			color_tx = '#1E0AE6'
			self.optSetColor(color_rx, color_tx, new)
		return (color_rx, color_tx)

	#возвращает строку формата времени в Qt стиле, установленную через настройки
	def optGetDateTimeFormat(self):
		new = True
		SQL = "SELECT date_format_view FROM 'main'.'options'"
		try:
			self.cur.execute(SQL)
			date_format_view = self.cur.fetchone()[0]
			if date_format_view == None:
				new = False
				raise Exception("DateTime format not define. Set default")
		except Exception, E:
			print "MyDB::optGetDateTimeFormat(): %s\n"%E
			#date_format_view = 'yyyy.MM.dd HH:mm:ss'
			date_format_view = 'yyyy-MM-dd HH:mm:ss'
			self.optSetDateTimeFormat(date_format_view, new)
		return date_format_view

	#устанавливает строку формата времени
	def optSetDateTimeFormat(self, date_format_view, new = False):
		if new:
			SQL = "INSERT INTO 'main'.'options' (date_format_view) VALUES ('%s')"%(date_format_view)
		else:
			SQL = "UPDATE 'main'.'options' SET date_format_view='%s'"%(date_format_view)

		ok = True
		try:
			self.cur.execute( SQL )
		except Exception, E:
			print SQL
			print "MyDB::optSetDateTimeFormat(): %s\n"%E
			ok = False
		return ok
	
	#возвращает период сбора данных статистики демоном 
	def optGetFreqTraffDaemon(self):
		new = True
		SQL = "SELECT freq_traff_daemon FROM 'main'.'options'"
		try:
			self.cur.execute(SQL)
			freq_traff_daemon = self.cur.fetchone()[0]
			if freq_traff_daemon == None:
				new = False
				raise Exception("Data collection period is not defined. Set default")
		except Exception, E:
			print "MyDB::optGetFreqTraffDaemon(): %s\n"%E
			freq_traff_daemon = 20
			self.optSetFreqTraffDaemon(freq_traff_daemon, new)
		return freq_traff_daemon

	#устанавливает частоту сбора инф. о трафике демоном qnetman
	def optSetFreqTraffDaemon(self, freq_traff_daemon, new = False):
		if new:
			SQL = "INSERT INTO 'main'.'options' (freq_traff_daemon) VALUES ('%s')"%(freq_traff_daemon)
		else:
			SQL = "UPDATE 'main'.'options' SET freq_traff_daemon='%s'"%(freq_traff_daemon)

		ok = True
		try:
			self.cur.execute( SQL )
		except Exception, E:
			print SQL
			print "MyDB::optSetFreqTraffDaemon(): %s\n"%E
			ok = False
		return ok
	
	#возвращает длительность сбора статистики по трафику 
	def optGetLimitSizeDB(self):
		new = True
		SQL = "SELECT limit_size_db FROM 'main'.'options'"
		try:
			self.cur.execute(SQL)
			limit_size_db = self.cur.fetchone()[0]
			if limit_size_db == None:
				new = False
				raise Exception("Limit db not define. Set default")
		except Exception, E:
			print "MyDB::optGetLimitSizeDB(): %s\n"%E
			limit_size_db = 0 #non limit
			self.optSetLimitSizeDB(limit_size_db, new)
		return limit_size_db

	#устанавливает длительность сбора статистики по трафику
	def optSetLimitSizeDB(self, limit_size_db, new = False):
		if new:
			SQL = "INSERT INTO 'main'.'options' (limit_size_db) VALUES ('%s')"%(limit_size_db)
		else:
			SQL = "UPDATE 'main'.'options' SET limit_size_db='%s'"%(limit_size_db)

		ok = True
		try:
			self.cur.execute( SQL )
		except Exception, E:
			print SQL
			print "MyDB::optSetLimitSizeDB(): %s\n"%E
			ok = False
		return ok


	#-----------------------#
	# Добавляет указанный сетевой интерфейс в список поддерживаемых в QNetworkManager
	def optAddSupportIface(self, iface, type_iface):
		SQL = "INSERT INTO 'main'.'type' (id, iface) VALUES (%s, '%s')"%(type_iface, iface)
		ok = True
		try:
			self.cur.execute( SQL )
		except Exception, E:
			print "MyDB::optAddSupportIface(): [%s] %s\n"%(SQL, E)
			ok = False
		return ok

	
	# Удаляет указанный сетевой интерфейс из списка поддерживаемых в QNetworkManager
	def optDelSupportIface(self, iface, type_iface):
		SQL = "DELETE FROM 'main'.'type' WHERE `iface` == '%s' AND `id` == %s"%(iface, type_iface)
		ok = True
		try:
			self.cur.execute( SQL )
		except Exception, E:
			print "MyDB::optDelSupportIface(): [%s] %s\n"%(SQL, E)
			ok = False
		return ok

	
	# Возвращает список интерфейсов, по которым включена поддержка в программе QNetworkManager
	def optGetSupportIface(self):
		SQL = "SELECT * FROM 'main'.'type'"
		bufReturn = list()
		try:
			j = 0
			for row in self.cur.execute( SQL ):
				nif = {}
				nif["type"] = row[0]
				nif["iface"] = row[1]
				nif['autorec'] = row[2]
				bufReturn.append( nif )
		except Exception, E:
			print "MyDB::optGetSupportIface(): [%s] %s\n"%(SQL, E)
		return bufReturn


	#Возвращает число поддерживаемых сетевых интерфейсов в списке
	def optGetNumSupportIface(self):
		SQL = "SELECT count(*) FROM 'main'.'type'"

		try:
			self.cur.execute( SQL )
			ret = self.cur.fetchone()[0]
			if ret == None:
				raise
		except Exception, E:
			print "MyDB::optGetNumSupportIface(): [%s] %s\n"%(SQL,E)
			ret = 0
		return ret
	#-----------------------#

	
	#функция статистики БД: возвращает число записей в таблице трафика
	def statNumRecTraff(self):
		SQL = "SELECT count(*) FROM 'main'.'traff'"

		try:
			self.cur.execute( SQL )
			ret = self.cur.fetchone()[0]
			if ret == None:
				raise
		except Exception, E:
			print "MyDB::statNumRecTraff(): [%s] %s\n"%(SQL,E)
			ret = 0
		return ret


	#функция статистики БД: возвращает число записей в таблице сессий
	def statNumRecSess(self):
		SQL = "SELECT count(*) FROM 'main'.'session'"

		try:
			self.cur.execute( SQL )
			ret = self.cur.fetchone()[0]
			if ret == None:
				raise
		except Exception, E:
			print "MyDB::statNumRecSess(): [%s] %s\n"%(SQL,E)
			ret = 0
		return ret
	
	
	#функция статистики БД: возвращает дату первой и последней записи
	def statDateRec(self):
		SQL = "SELECT `timestamp` FROM `traff` WHERE id= ( SELECT MAX(id) FROM 'main'.'traff' )"
		try:
			self.cur.execute( SQL )
			retLast = self.cur.fetchone()[0]
			if retLast == None:
				raise
		except Exception, E:
			print "MyDB::statDateRec(): [%s] %s\n"%(SQL,E)
			retLast = 0
		
		SQL = "SELECT `timestamp` FROM `traff` WHERE id= ( SELECT MIN(id) FROM 'main'.'traff' )"
		try:
			self.cur.execute( SQL )
			retFirst = self.cur.fetchone()[0]
			if retFirst == None:
				raise
		except Exception, E:
			print "MyDB::statDateRec(): [%s] %s\n"%(SQL,E)
			retFirst = 0
		return (retFirst, retLast)


	#--- автозапись данных ---#
	def autoRecEnable( self, type, enable ):
		if enable:
			SQL = "UPDATE 'main'.'type' SET auto_rec=1 WHERE id = %s;"%type
		else:
			SQL = "UPDATE 'main'.'type' SET auto_rec=0 WHERE id = %s;"%type

		ok = True
		try:
			self.cur.execute( SQL )
		except Exception, E:
			print SQL
			print "MyDB::autoRecEnable(): %s\n"%E
			ok = False
		return ok
	
	def isAutoRecEnable(self, type):
		SQL = "SELECT auto_rec FROM 'main'.'type' WHERE id = %s;"%type

		try:
			self.cur.execute( SQL )
			ret = self.cur.fetchone()[0]
			if ret == 1:
				ret = True
			if ret == None:
				raise
		except Exception, E:
			print "MyDB::isAutoRecEnable(): [%s] %s\n"%(SQL,E)
			ret = False

		return ret
