# -*- coding: utf-8 -*-

from PySide import QtCore, QtGui

from ListSessions import Ui_ListSessions
from ViewSessionExt import ViewSessionExt
from WindowFilterOptionsExt import WindowFilterOptionsExt
from MyItemDelegate import MyItemDelegate
import DialogDBStatistics
import StatistData

from mydb import MyDB
import myconfig


class ListSessionsExt( QtGui.QMainWindow ):
	def __init__(self, parent = None):
		QtGui.QMainWindow.__init__( self, parent )
		self.parent = parent
		
		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
		except Exception, e:
			pass
			#print "ListSessionsExt::__init__(): Exception setAttribute(): ",e

		self.ui = Ui_ListSessions()
		self.ui.setupUi( self )
		self.actionForm()
		#self.setWindowTitle( "QNetMan" )
		
		self.db = MyDB( myconfig.file_db )
		
		#хранит текущий выбраный пункт списка - сессию
		self.currentSelectedItem = None
		
		#параметры фильтра
		self.startTime_filter = None
		self.endTime_filter = None
		self.sessionType_filter = 0

	def actionForm(self):
		self.ui.listWidgetSessions.itemClicked.connect( self.clickedItem )
		self.ui.listWidgetSessions.itemChanged.connect( self.itemChanged )
		self.ui.pBVSelectedAll.clicked.connect( self.selectedAllItems )
		self.ui.pBDeleteItem.clicked.connect( self.removeItems )
		self.ui.pBViewItem.clicked.connect( self.viewSession )
		self.ui.pBFilter.toggled.connect( self.winFilter )
		
		QtCore.QObject.connect(self.ui.action_dbstat, QtCore.SIGNAL("triggered()"), self.DlgDBStatistics)

		self.ui.listWidgetSessions.setAlternatingRowColors( True )
		
		plugin = MyItemDelegate( self, 1 )
		self.ui.listWidgetSessions.setItemDelegate( plugin )

#	def keyReleaseEvent(self, ev):
#		if ev.key() == 65:
#			for(i=0; i<sel.ui.listWidgetSessions.count(); i+=1):
#				self.ui.listWidgetSessions.item(i)
#		print "key=%s"%ev.key()


	#состояние пункта изменяется (установилась/снялась галка) (слот)
	def itemChanged(self):
		j = 0
		flSelected = False
		while j < self.ui.listWidgetSessions.count():
			#if self.ui.listWidgetSessions.item(j).checkState() == QtCore.Qt.Checked:
			if self.ui.listWidgetSessions.item(j).data(QtCore.Qt.UserRole+3) == 1:
				flSelected = True
				break
			j += 1
		#кнопка удаления будет неактивна, если нет выбранных пунктов
		if flSelected:
			self.ui.pBDeleteItem.setEnabled( True )
		else:
			self.ui.pBDeleteItem.setEnabled( False )


	#клик по пункту (слот)
	def clickedItem(self, item):
		self.ui.pBViewItem.setEnabled( True )
		self.currentSelectedItem = item
		if item.data(QtCore.Qt.UserRole+3) == 1:
			item.setData( QtCore.Qt.UserRole+3, 0 )
		else:
			item.setData( QtCore.Qt.UserRole+3, 1 )


	#удаляет выбранные пункты списка
	def removeItems(self):
		j = 0
		if self.ui.listWidgetSessions.count():
			txt1 = QtGui.QApplication.translate("ListSessionsExt", "Deleting sessions", None, QtGui.QApplication.UnicodeUTF8)
			txt2 = QtGui.QApplication.translate("ListSessionsExt", "Delete selected sessions ?", None, QtGui.QApplication.UnicodeUTF8)
			res = QtGui.QMessageBox.question(self, txt1, txt2, QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
			if res != QtGui.QMessageBox.Yes:
				return
		while j < self.ui.listWidgetSessions.count():
			item = self.ui.listWidgetSessions.item(j)
			if item.data(QtCore.Qt.UserRole+3) == 1:
				#удаляем из БД
				start_t = self.listSessionItems[j]["start"]
				stop_t = self.listSessionItems[j]["stop"]
				ok = self.db.cleanDBbyTime( start_t, stop_t )
				if ok == True:
					#удаляем из списка
					self.ui.listWidgetSessions.takeItem( j )
					del item
					#удаляем из буфера
					del(self.listSessionItems[j])
				else:
					txt1 = QtGui.QApplication.translate("ListSessionsExt", "Error", None, QtGui.QApplication.UnicodeUTF8)
					txt2 = QtGui.QApplication.translate("ListSessionsExt", "Sorry, an error in the database.", None, QtGui.QApplication.UnicodeUTF8)
					QtGui.QMessageBox.critical(self, txt1, txt2)
					break
				continue
			j += 1
		
		#если список остался пуст - кнопка просмотра запрещена
		if len(self.ui.listWidgetSessions.selectedItems()) == 0:
			self.ui.pBViewItem.setEnabled( False )
		self.itemChanged()


	#расставляет "галки" на всех пунктах списка
	def selectedAllItems(self):
		j = 0
		while j < self.ui.listWidgetSessions.count():
			#if self.ui.listWidgetSessions.item(j).checkState() == QtCore.Qt.Checked:
			if self.ui.listWidgetSessions.item(j).data(QtCore.Qt.UserRole+3) == 1:
				#self.ui.listWidgetSessions.item(j).setCheckState( QtCore.Qt.Unchecked )
				self.ui.listWidgetSessions.item(j).setData( QtCore.Qt.UserRole+3, 0 )
			else:
				#self.ui.listWidgetSessions.item(j).setCheckState( QtCore.Qt.Checked )
				self.ui.listWidgetSessions.item(j).setData( QtCore.Qt.UserRole+3, 1 )
			j += 1


	#добавляет в список сессий пункт сессии
	def addItemSession(self, textItem, typeS, timeS, traffS):
		item_pic = ""
		if typeS == "gprs0":
			item_pic = ":/pic48/pictures/gprs.png"
		elif typeS == "wlan0":
			item_pic = ":/pic48/pictures/wifi.png"
		elif typeS == "pan0":
			item_pic = ":/pic48/pictures/pan.png"
		elif ( typeS == "eth0" ):
			item_pic = ":/pic48/pictures/eth.png"
		elif ( typeS == "usb0" ):
			item_pic = ":/pic48/pictures/usb.png"
		else:
			item_pic = ":/pic48/pictures/unknown.png"
		item = QtGui.QListWidgetItem()

		txt = QtGui.QApplication.translate("ListSessionsExt", "Session full time:", None, QtGui.QApplication.UnicodeUTF8)
		descr = "%s %s"%(txt, timeS)
		if traffS != "":
			descr += "   " + traffS
		item.setData( QtCore.Qt.StatusTipRole,textItem )
		item.setData( QtCore.Qt.UserRole+1, descr )
		item.setData( QtCore.Qt.UserRole+2, item_pic )
		item.setData( QtCore.Qt.UserRole+3, 0 )

		self.ui.listWidgetSessions.addItem( item )


	def initItemsSession(self, startTime = None, endTime = None, filterType = 0):
		#параметры включеного фильтра
		self.startTime_filter = startTime
		self.endTime_filter = endTime
		self.sessionType_filter = filterType

		#список сессий из БД
		if filterType == 0:
			self.listSessionItems = self.db.getFullListSession( startTime, endTime )
		else:
			typeSess_id = filterType
			self.listSessionItems = self.db.getListSession( filterType, startTime, endTime )
		#очищаем виджет списка
		self.ui.listWidgetSessions.clear()
		#создаем пункты списка - сессии
		j = 0
		len_buff = len( self.listSessionItems )
		while j < len_buff:
			strFormatDateTime = self.db.optGetDateTimeFormat()

			start = QtCore.QDateTime.fromString( self.listSessionItems[j]["start"], "yyyy-MM-dd HH:mm:ss")
			start = start.toString( strFormatDateTime )

			stop = QtCore.QDateTime.fromString( self.listSessionItems[j]["stop"], "yyyy-MM-dd HH:mm:ss")
			stop = stop.toString( strFormatDateTime )

			str = "%s - %s"%(start, stop)
			
			if filterType == 0:
				typeSess_id = self.listSessionItems[j]["type_session"]
			typeSess = self.db.getIfaceByType( typeSess_id )

			(h,m,s) = StatistData.sessionTime( self.listSessionItems[j]["start"], self.listSessionItems[j]["stop"] )
			longTimeSess = "%02d:%02d:%02d"%(h,m,s)

			strTraff = ""
			bufTraff = self.db.getTraffByTime( self.listSessionItems[j]["start"], self.listSessionItems[j]["stop"], typeSess_id )
			l = len(bufTraff)
			if l > 1:
				(rx, tx) = StatistData.traffSession( bufTraff )
				rx = StatistData.strHumanBytes( rx )
				tx = StatistData.strHumanBytes( tx )
				strTraff = "rx/tx: %s/%s"%( rx, tx )

			self.addItemSession( str, typeSess, longTimeSess, strTraff )
			j += 1
		
		if len(self.ui.listWidgetSessions.selectedItems()) == 0:
			self.ui.pBViewItem.setEnabled( False )
			self.itemChanged()


	def viewSession(self):
		#номер текущего пункта
		row = self.ui.listWidgetSessions.row( self.currentSelectedItem )

		#длительность сессии в секундах
		(h,m,s) = StatistData.sessionTime( self.listSessionItems[row]["start"], self.listSessionItems[row]["stop"] )
		allSeconds = 3600*h + 60*m + s
		
		#получаем из БД трафик сессии
		buf = self.db.getTraffByTime( self.listSessionItems[row]["start"], self.listSessionItems[row]["stop"],self.listSessionItems[row]["type_session"])

		#проверяем наличие необходимого кол-ва данных, для постороения графика
		len_buf = len( buf )
		if len_buf < 1:
			txt1 = QtGui.QApplication.translate("ListSessionsExt", "Warning", None, QtGui.QApplication.UnicodeUTF8)
			txt2 = QtGui.QApplication.translate("ListSessionsExt", "Session does not contain data", None, QtGui.QApplication.UnicodeUTF8)
			QtGui.QMessageBox.warning(self, txt1, txt2)
			return
		elif len_buf == 1:
			el0 = buf[0]
			buf[0]["rx"] = "0"
			buf[0]["tx"] = "0"
			buf[0]["timestamp"] = self.listSessionItems[row]["start"]
			el0["timestamp"] = self.listSessionItems[row]["stop"]
			buf[0]["type_session"] = el0["type_session"]
			buf[1] = el0
			
		self.mwViewSession = ViewSessionExt( self, self.currentSelectedItem.text(), buf )
		self.mwViewSession.show()
		self.mwViewSession.setTimeSession( allSeconds, h, m, s )
		self.mwViewSession.showData()

	def winFilter(self, state):
		if state:
			self.mwFilterOptions = WindowFilterOptionsExt( self, self.ui )
			self.mwFilterOptions.show()
		else:
			self.initItemsSession()

	#--- диалог со статистикой БД ---
	def DlgDBStatistics(self):
		self.dlgDBStat = QtGui.QDialog()
		self.ui_dlgDBStat = DialogDBStatistics.Ui_DialogDBStat()
		self.ui_dlgDBStat.setupUi( self.dlgDBStat )

		self.ui_dlgDBStat.pB_Done.clicked.connect( self.dlgDBStat.hide )

		f_db = QtCore.QFileInfo( myconfig.file_db )
		if f_db.exists():
			#размер файла БД
			siz_db = f_db.size()
			if siz_db > 1048576:
				strSize = "%.2f MB"%( siz_db/1048576.0 )
			elif siz_db > 1024:
				strSize = "%.2f kB"%( siz_db/1024.0 )
			else:
				strSize = "%s B"%( siz_db )
			self.ui_dlgDBStat.lblFileSizeVal.setText( strSize )

			#число записей трафика
			numTr = self.db.statNumRecTraff()
			txt = QtGui.QApplication.translate("ListSessionsExt", "records", None, QtGui.QApplication.UnicodeUTF8)
			self.ui_dlgDBStat.lblTraffStatVal.setText( "%s %s"%(numTr, txt) )

			#число записей сессий
			numTr = self.db.statNumRecSess()
			self.ui_dlgDBStat.lblSesStatVal.setText( "%s %s"%(numTr, txt) )

			#дата первой и последней записи
			first, last = self.db.statDateRec()
			self.ui_dlgDBStat.lblFirstEntryVal.setText( "%s"%first )
			self.ui_dlgDBStat.lblLastEntryVal.setText( "%s"%last )

		self.dlgDBStat.show()
	



