# Add more folders to ship with the application, here
folder_01.source = qml/qalculette
folder_01.target = qml
DEPLOYMENTFOLDERS = folder_01

# Additional import path used to resolve QML modules in Creator's code model
QML_IMPORT_PATH =

symbian:TARGET.UID3 = 0xE05C685C

# Smart Installer package's UID
# This UID is from the protected range and therefore the package will
# fail to install if self-signed. By default qmake uses the unprotected
# range value if unprotected UID is defined for the application and
# 0x2002CCCF value if protected UID is given to the application
#symbian:DEPLOYMENT.installer_header = 0x2002CCCF

# Allow network access on Symbian
symbian:TARGET.CAPABILITY += NetworkServices

# If your application uses the Qt Mobility libraries, uncomment the following
# lines and add the respective components to the MOBILITY variable.
# CONFIG += mobility
# MOBILITY +=

# Speed up launching on MeeGo/Harmattan when using applauncherd daemon
CONFIG += qdeclarative-boostable

# Add dependency to Symbian components
# CONFIG += qt-components


# The .cpp file which was generated for your project. Feel free to hack it.
SOURCES += main.cpp \
    lib/operand.cpp \
    lib/complex.cpp \
    lib/operands/multiplication.cpp \
    lib/operands/number.cpp \
    lib/operands/addition.cpp \
    lib/operands/power.cpp \
    lib/operands/function.cpp \
    lib/operandfactory.cpp \
    lib/factories/operatorsfactory.cpp \
    ui/calcserver.cpp

# Please do not modify the following two lines. Required for deployment.
include(qmlapplicationviewer/qmlapplicationviewer.pri)
qtcAddDeployment()

OTHER_FILES += \
    qtc_packaging/debian_harmattan/rules \
    qtc_packaging/debian_harmattan/README \
    qtc_packaging/debian_harmattan/manifest.aegis \
    qtc_packaging/debian_harmattan/copyright \
    qtc_packaging/debian_harmattan/control \
    qtc_packaging/debian_harmattan/compat \
    qtc_packaging/debian_harmattan/changelog \
    qtc_packaging/debian_fremantle/rules \
    qtc_packaging/debian_fremantle/README \
    qtc_packaging/debian_fremantle/copyright \
    qtc_packaging/debian_fremantle/control \
    qtc_packaging/debian_fremantle/compat \
    qtc_packaging/debian_fremantle/changelog

HEADERS += \
    lib/operand.h \
    lib/complex.h \
    lib/operands/multiplication.h \
    lib/operands/number.h \
    lib/operands/addition.h \
    lib/operands/power.h \
    lib/operands/function.h \
    lib/operandfactory.h \
    lib/factories/operatorsfactory.h \
    ui/calcserver.h

maemo5 {
   INSTALLS += target desktop icon48
   target.path = /usr/bin/qalculette
   desktop.path = /usr/share/applications/hildon
   desktop.files += maemofiles/qalculette.desktop
   icon48.path = /usr/share/icons/hicolor/48x48/apps
   icon48.files += maemofiles/qalculette48.png
}






































