# -*- coding: utf-8 -*-
import sys, os, time
import random, datetime


from sql_midgard import *
#from sql_sqlite import *


if __name__ == '__main__':
    if SQLConnection.dbtype() == "midgard":
        conn = SQLConnection("./test.sqlite", "schema_midgard.cfg", "/home/pp/testblobs")
    else:
        conn = SQLConnection("./test.sqlite", "schema.cfg", "/home/user/testblobs")
    conn.create_database()
    conn.set_commit_limit(1000)
    start = datetime.datetime.now()
    for i in range(1, 1001):
        o = SQLObject("message")
        try:
            o.get_by("id", int(i))
        except Exception:
            o = SQLObject("message")
            o.message = "test %s" % (i)
            o.create()
    conn.commit(True)
    end = datetime.datetime.now()
    print (end - start)

    start = datetime.datetime.now()
    q = SQLQuery("message")
    print q.count()
    r = q.execute()
    for o in r:
        o.delete()
    conn.commit(True)
    end = datetime.datetime.now()
    print (end - start)
