# -*- coding: utf-8 -*-
import ConfigParser
import time

from sql import *
from config import Config


class Channel(object):
    def __init__(self, param = None):
        if isinstance(param, int):
            self.object = SQLObject("channel")
            self.object.get_by("id", param)
        elif isinstance(param, str):
            self.object = SQLObject("channel")
            self.object.get_by("name", param)
        elif param == None:
            self.object = SQLObject("channel")
        else:
            self.object = param


    @staticmethod
    def channelCreate(name):
        q = SQLQuery("channel")
        q.add_constraint("name", "=", str(name))
        r = q.execute()
        channel = None
        if len(r) > 0:
            channel = r[0]
        else:
            channel = SQLObject("channel")
            channel.name = name
            channel.title = name
            channel.create()
            
        return Channel(channel)


    @staticmethod
    def channelGetAll():
        q = SQLQuery("channel")
        q.add_order("name", "ASC")
        r = q.execute()
        channels = []
        for channel in r:
            channels.append(Channel(channel))
        return channels


    # Overloaded getter function to handle direct request of variables from Midgard objects
    def __getattr__(self, name):
        if name == 'object':
            return self.__dict__[name]
        try:
            return getattr(self.object, name)
        except AttributeError:
            print "WARNING: __getattr__ function of class ("+self.__class__.__name__+") didn't find requested attribute ('"+name+"') in object ("+self.__dict__['object'].__class__.__name__+")."
            # Get non-persistent values (not members of Midgard object) from this object
            return self.__dict__[name]
        return False

            
    # Overloaded setter function to handle direct setting of variables to Midgard objects
    def __setattr__(self, name, value):
        if name == 'object':
            self.__dict__[name] = value   
            return True 
        try:
            setattr(self.object, name, value)
        except AttributeError:
            print "WARNING: __setattr__ function of class ("+self.__class__.__name__+") didn't find requested attribute ('"+name+"') in object ("+self.__dict__['object'].__class__.__name__+")."
            # Set non-persistent values (not members of Midgard object) to this object
            self.__dict__[name] = value
        return True

        
    # Overload Midgard object's create function      
    def create(self):    
        self.object.create()
        # TODO: Tassa kohtaa lisataan synkronointitauluun kaamaa

        print self.__class__.__name__+" object created"


    # Overload Midgard object's update function      
    def update(self):
        self.object.update()
        # TODO: Tassa kohtaa lisataan synkronointitauluun kaamaa

        print self.__class__.__name__+" object updated"


    # Overload Midgard object's delete function      
    def delete(self):
        self.object.delete()
        # TODO: Tassa kohtaa lisataan synkronointitauluun kaamaa

        print self.__class__.__name__+" object deleted"


    def getName(self):
        return str(self.object.name)


    # get channel avatar
    def getLogo(self):
        path = self.object.blobPath("logo")
        if path == None:
            path = "data/channel_no_logo.gif"
        return path


    def writeLogoData(self, data):
        self.object.blobWrite("logo", data)


