#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "ui_aboutwindow.h"


//Creating procwatch object, needed for /proc/psfreedom/status reading.

procwatch *myProcWatch = new procwatch(0);

// Constructor

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    // setup the UI
    ui->setupUi(this);
    ui->jailbreakOffButton->hide();
    ui->firmwareList->hide();
    // Set background
    //QMainWindow::setStyleSheet(("MainWindow { background-image: url(:/images/images/psfreedombg.png); }"));
    this->setBackgroundImage(":/images/images/psfreedombg.png");
#ifdef Q_WS_MAEMO_5
    // Set stacked window attribute to the main window.
    setAttribute(Qt::WA_Maemo5StackedWindow);
    // Allow portrait mode.
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    // connect all UI buttons to their functions
    connectSignals();
    // Show "Ready" in status bar
    statusBar()->showMessage(tr("Ready"));
    qDebug() << "MainWindow: UI ready.";
}

// About, ties with aboutwindow.(cpp/h)

void MainWindow::about()
{
    setWindowFlags(windowFlags() | Qt::Window);
    AboutWindow *myAboutWindow = new AboutWindow(this);
    myAboutWindow->show();
}

// Games list.
void MainWindow::CL()
{
    setWindowFlags(windowFlags() | Qt::Window);
    CompatibilityWindow *myCompatibilityWindow = new CompatibilityWindow(this);
    myCompatibilityWindow->show();
}

// Kernel Messages, currently a black QTextBrowser.

void MainWindow::kernelmessages()
{
    setWindowFlags(windowFlags() | Qt::Window);
    KernelMessagesWindow *myKernelMessagesWindow = new KernelMessagesWindow(this);
    myKernelMessagesWindow->showLogs();
    myKernelMessagesWindow->show();
}

void MainWindow::helpWindow()
{
    setWindowFlags(windowFlags() | Qt::Window);
    HelpWindow *myHelpWindow = new HelpWindow(this);
    myHelpWindow->show();
}

// Jailbreak mode on, PL3

void MainWindow::jailbreakOn()
{
    ui->jailbreakOnHermesButton->hide();
    // Detect modules, load appropriate ones based on kernel.
    qDebug() << "Detecting modules...";
    system("sudo psfreedom-enable-n900.sh --pl3");
#ifdef Q_WS_MAEMO_5
    // Yellow information bar
    QMaemo5InformationBox::information(0, tr("Jailbreak mode enabled"));
#endif
    // Start QTimer!
    qDebug() << "MainWindow: Starting QTimer...";
    myProcWatch->startTimer();
    // Hide on button
    ui->jailbreakOnButton->hide();
    // Show off button
    ui->jailbreakOffButton->show();
    // Show firmware combobox
    ui->firmwareList->show();
    // Update status message
    statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.41"));
    // Terminate all led scripts so they don't conflict
    // We don't use ledon.sh anymore, less CPU alternative is mce.
    //  system("killall ledon.sh 2> /dev/null");
    // Start red LED, this is a bit CPU intensive....
    // system("./ledon.sh red &");
    // Use mce instead, not CPU intensive, but requires edits in mce.ini :D
    qDebug() << "MainWindow: starting red LED...";
    system("dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_activate string:'PatternJailbreakStarted'");
    system("touch /home/user/.psfreedom_ran");
    QFile file("/home/user/.psfreedom_ran");
    file.open(QIODevice::ReadOnly | QIODevice::Text);
    QTextStream in(&file);
    QString appstatus = in.readLine();
    if (appstatus == "Started"){
        qDebug() << "MainWindow: this is not the first run.";
     } else {
        qDebug() << "MainWindow: first startup detected, showing help window.";
        MainWindow::helpWindow();
        system("echo Started > /home/user/.psfreedom_ran");
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(0, tr("PSFreedom has detected that this is the first run."));
#endif
    }
}

// Hermes

void MainWindow::jailbreakOnHermes()
{
    ui->jailbreakOnButton->hide();
    // Detect modules, load appropriate ones based on kernel.
    qDebug() << "Detecting modules...";
    system("sudo psfreedom-enable-n900.sh --hermes");
#ifdef Q_WS_MAEMO_5
    // Yellow information bar
    QMaemo5InformationBox::information(0, tr("Jailbreak mode enabled"));
#endif
    // Start QTimer!
    qDebug() << "MainWindow: Starting QTimer...";
    myProcWatch->startTimer();
    // Hide on button
    ui->jailbreakOnHermesButton->hide();
    // Show off button
    ui->jailbreakOffButton->show();
    // Don't show firmware list, hermes doesn't have support for different firmwares(???)
    // ui->firmwareList->hide();
    // Update status message
    statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.41"));
    // Terminate all led scripts so they don't conflict
    // We don't use ledon.sh anymore, less CPU alternative is mce.
    //  system("killall ledon.sh 2> /dev/null");
    // Start red LED, this is a bit CPU intensive....
    // system("./ledon.sh red &");
    // Use mce instead, not CPU intensive, but requires edits in mce.ini :D
    qDebug() << "MainWindow: starting red LED...";
    system("dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_activate string:'PatternJailbreakStarted'");
    system("touch /home/user/.psfreedom_ran");
    QFile file("/home/user/.psfreedom_ran");
    file.open(QIODevice::ReadOnly | QIODevice::Text);
    QTextStream in(&file);
    QString appstatus = in.readLine();
    if (appstatus == "Started"){
        qDebug() << "MainWindow: this is not the first run.";
     } else {
        qDebug() << "MainWindow: first startup detected, showing help window.";
        MainWindow::helpWindow();
        system("echo Started > /home/user/.psfreedom_ran");
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(0, tr("PSFreedom has detected that this is the first run."));
#endif
    }
}

// Jailbreak mode off, what do when the button is pressed

void MainWindow::jailbreakOff()
{
    myProcWatch->stopTimer();
    qDebug() << "MainWindow: disabling jailbreak mode.";
    system("sudo psfreedom-disable-n900.sh");
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(0, tr("Jailbreak mode disabled"));
#endif
    ui->jailbreakOnButton->show();
    ui->jailbreakOnHermesButton->show();
    ui->jailbreakOffButton->hide();
    // Hide firmware combobox
    ui->firmwareList->hide();
    statusBar()->showMessage(tr("Jailbreak mode disabled"));
    // Turn off LEDs using dbus, need to use proper dbus here...
    qDebug() << "MainWindow: Turning off LEDs.";
    system("run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_deactivate string:'PatternJailbreakComplete'");
    system("run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_deactivate string:'PatternJailbreakStarted'");
}

void MainWindow::selectFirmware(int index)
{
    switch (index) {
    case 0:
        qDebug() << "MainWindow: selecting 3.41.";
        system("echo 3.41 > /proc/psfreedom/fw_version");
        statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.41"));
        break;
    case 1:
        qDebug() << "MainWindow: selecting 3.15.";
        system("echo 3.15 > /proc/psfreedom/fw_version");
        statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.15"));
        break;
    case 2:
        qDebug() << "MainWindow: selecting 3.10.";
        system("echo 3.10 > /proc/psfreedom/fw_version");
        statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.10"));
        break;
    case 3:
        qDebug() << "MainWindow: selecting 3.01.";
        system("echo 3.01 > /proc/psfreedom/fw_version");
        statusBar()->showMessage(tr("Jailbreak mode enabled. Firmware: 3.01"));
    }
}

void MainWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()){
        // Landscape mode
        qDebug() << "MainWindow: Orientation changed: Landscape.";
        //QMainWindow::setStyleSheet(("MainWindow { background-image: url(:/images/images/psfreedombg.png); }"));
        this->setBackgroundImage(":/images/images/psfreedombg.png");
        ui->jailbreakOffButton->setGeometry(QRect(200, 220, 447, 70));
        ui->jailbreakOnButton->setGeometry(QRect(190, 220, 221, 70));
        ui->jailbreakOnHermesButton->setGeometry(QRect(420, 220, 221, 70));
        ui->firmwareList->setGeometry(QRect(390, 310, 61, 51));
        ui->menuFile->addAction(ui->actionHelp);
    }
    else {
        // Portrait mode
        qDebug() << "MainWindow: Orientation changed: Portrait.";
        //QMainWindow::setStyleSheet(("MainWindow { background-image: url(:/images/images/psfreedomportraitbg.png); }"));
        this->setBackgroundImage(":/images/images/psfreedomportraitbg.png");
        ui->jailbreakOffButton->setGeometry(QRect(20, 370, 447, 70));
        ui->jailbreakOnButton->setGeometry(QRect(20, 370, 221, 70));
        ui->jailbreakOnHermesButton->setGeometry(QRect(240, 370, 221, 70));
        ui->firmwareList->setGeometry(QRect(220, 500, 70, 60));
        ui->menuFile->removeAction(ui->actionHelp);
    }
}

void MainWindow::connectSignals()
{
    connect(ui->jailbreakOnButton, SIGNAL(clicked()), this, SLOT(jailbreakOn())); // on button
    connect(ui->jailbreakOnHermesButton, SIGNAL(clicked()), this, SLOT(jailbreakOnHermes())); // on (hermes) button
    connect(ui->jailbreakOffButton, SIGNAL(clicked()), this, SLOT(jailbreakOff())); // off button
    connect(ui->actionAbout, SIGNAL(triggered()), this, SLOT(about())); // about menu item
    connect(ui->actionKernel_Messages, SIGNAL(triggered()), this, SLOT(kernelmessages())); // kernel messages menu item
    connect(ui->actionHelp, SIGNAL(triggered()), this, SLOT(helpWindow())); // help window
    connect(ui->actionAbout_Qt, SIGNAL(triggered()), qApp, SLOT(aboutQt())); // about Qt
    connect(ui->actionCompatibility_list, SIGNAL(triggered()), this, SLOT(CL())); // Compatibility Browser
    connect(ui->firmwareList, SIGNAL(activated(int)), this, SLOT(selectFirmware(int))); // Firmware list
#ifdef Q_WS_MAEMO_5
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
#endif
}

void MainWindow::setBackgroundImage(const QString &image)
{
    this->m_BackgroundImage = image;
    this->update();
}

void MainWindow::paintEvent(QPaintEvent*)
{
    QPainter painter(this);

    painter.drawImage(this->rect(), QImage(this->m_BackgroundImage));
}

// Destorys the MainWindow

MainWindow::~MainWindow()
{
    qDebug() << "MainWindow: caught quit signal, exiting...";
    jailbreakOff();
    delete ui;
}
