#include <QtGui>
#include "proximityclock-clock.h"
#include <QDebug>

QString bg = "background-color:rgb(";
QString fg = "color:rgb(";

DigitalClock::DigitalClock(QWidget *parent)
    : QLCDNumber(parent)
{
    setSegmentStyle(Filled);


    QFile file("/home/user/.proximityclock/.bg");
    if (file.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        while (!file.atEnd()) {
            QString line = file.readLine();

            QRegExp rx1("^bgcolor");//\\s*(\\d+)\\s*$");
            if (rx1.indexIn(line)>=0)
            {
                QRegExp rx("(\\d+)");
                int pos = 0;

                while ((pos = rx.indexIn(line, pos)) != -1) {
                    bg.append(rx.cap(1)).append(",");
                    pos += rx.matchedLength();
                }
                bg[(bg.size()-1)]=')';
            }
        }
    }
    file.close();

    QFile file1("/home/user/.proximityclock/.fg");
    if ( file1.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        while (!file1.atEnd()) {
            QString line = file1.readLine();

            QRegExp rx2("^fgcolor");
            if ( rx2.indexIn(line)>=0 )
            {
                QRegExp rx3("(\\d+)");
                int pos = 0;
                while ( (pos = rx3.indexIn(line,pos)) != -1 ) {
                    //qDebug() << " fg-found : " << qPrintable(rx3.cap(1)) << endl;
                    fg.append(rx3.cap(1)).append(",");
                    pos += rx3.matchedLength();
                }
                fg[(fg.size()-1)] = ')';
            }
        }
    }
    file1.close();



    //qDebug() << "stylesheet = * { " + bg + ";" + fg + " }}";

    setStyleSheet("* { " + bg + ";" + fg + " }}");//background-color:rgb(200,155,55);color:rgb(100,10,11)}}");
    
    bool isFullScreen = windowState() & Qt::WindowFullScreen;
    if (!isFullScreen)
	showFullScreen();

    QTimer *timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(showTime()));
    timer->start(1000);

    showTime();

    setWindowTitle(tr("Digital Clock"));
    resize(150, 60);
}

void DigitalClock::showTime()
{
    QTime time = QTime::currentTime();
    QString text = time.toString("hh:mm");
    if ((time.second() % 2) == 0)
        text[2] = ' ';
    display(text);
}
