#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include "query-tree-model.h"

static void
model_to_file(GtkTreeModel *tm)
{
	char *fname = g_strdup_printf("%s" G_DIR_SEPARATOR_S ".pogacsa", g_get_home_dir()), *tmpname = NULL;
	GtkTreeIter itr;
	GKeyFile *kf = g_key_file_new();
	char *name, *query, *icon;
	char *str;
	gsize str_size;
	int tmp_fd = -1;

	if (kf) {
		if (gtk_tree_model_get_iter_first(tm, &itr))
			do {
				gtk_tree_model_get(tm, &itr,
					QUERY_TREE_MODEL_NAME,      &name,
					QUERY_TREE_MODEL_QUERY,     &query,
					QUERY_TREE_MODEL_ICON_PATH, &icon,
					-1);

				g_key_file_set_string(kf, name, "query", query);
				g_key_file_set_string(kf, name, "icon",  icon);

				g_free(name);
				g_free(query);
				g_free(icon);

			} while (gtk_tree_model_iter_next(tm, &itr));

		str = g_key_file_to_data(kf, &str_size, NULL);

		tmp_fd = g_file_open_tmp("pogacsa.XXXXXX", &tmpname, NULL);

		if (-1 != tmp_fd) {
			char *cmd = g_strdup_printf("mv %s %s", tmpname, fname);
			write(tmp_fd, str, str_size);
			close(tmp_fd);
			if (system(cmd)) {
				g_warning("model_to_file: system(\"%s\") failed\n", cmd);
				unlink(tmpname);
			}
			g_free(cmd);
		}
		g_free(tmpname);
		g_free(str);
		g_key_file_free(kf);
	}

	g_free(fname);
}

GdkPixbuf *
query_tree_model_make_image(char *fname)
{
	GdkPixbuf *ret = gdk_pixbuf_new_from_file_at_size(fname, 48, 48, NULL);

	if (!ret)
		ret = gdk_pixbuf_new_from_file(DEFAULT_QUERY_ICON_FNAME, NULL);

	return ret;
}

void
query_tree_model_set(GtkTreeModel *tm, GtkTreeIter *itr, char *name, char *query, char *icon_fname)
{
	GtkListStore *ls = GTK_LIST_STORE(tm);
	GtkTreeIter local_itr;

	if (!itr) {
		gtk_list_store_append(ls, &local_itr);
		itr = &local_itr;
	}

	gtk_list_store_set(ls, itr,
		QUERY_TREE_MODEL_IMAGE,     query_tree_model_make_image(icon_fname),
		QUERY_TREE_MODEL_NAME,      name,
		QUERY_TREE_MODEL_QUERY,     query,
		QUERY_TREE_MODEL_ICON_PATH, icon_fname,
		-1);

	model_to_file(tm);
}

GtkTreeModel *
query_tree_model_new()
{
	GtkListStore *ls = NULL;
	GKeyFile *kf = g_key_file_new();

	ls = gtk_list_store_new(QUERY_TREE_MODEL_N_COLS, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

	if (kf) {
		char *fname = g_strdup_printf("%s" G_DIR_SEPARATOR_S ".pogacsa", g_get_home_dir());

		if (fname) {
			if (g_key_file_load_from_file(kf, fname, G_KEY_FILE_NONE, NULL)) {
				char **entries = g_key_file_get_groups(kf, NULL);

				if (entries) {
					char *query, *icon;
					int Nix;
					GtkTreeIter itr;

					for (Nix = 0 ; entries[Nix] ; Nix++) {
						query = g_key_file_get_string(kf, entries[Nix], "query", NULL);
						icon = g_key_file_get_string(kf, entries[Nix], "icon", NULL);

						if (query && icon) {
							gtk_list_store_append(ls, &itr);
							gtk_list_store_set(ls, &itr,
								QUERY_TREE_MODEL_IMAGE,     query_tree_model_make_image(icon),
								QUERY_TREE_MODEL_NAME,      entries[Nix],
								QUERY_TREE_MODEL_QUERY,     query,
								QUERY_TREE_MODEL_ICON_PATH, icon,
								-1);
						}

						g_free(query);
						g_free(icon);
					}
					g_strfreev(entries);
				}
			}

			g_free(fname);
		}
		g_key_file_free(kf);
	}

	return GTK_TREE_MODEL(ls);
}

void
query_tree_model_move(GtkTreeModel *tm, GtkTreeIter *itr, gboolean up)
{
	gboolean can_swap = FALSE;
	GtkTreeIter itr_other = *itr;

	if (up) {
		gint *indices;
		GtkTreePath *tp = gtk_tree_model_get_path(tm, itr);

		if (tp) {
			indices = gtk_tree_path_get_indices(tp);
			if (indices)
				if (indices[0]) {
					GtkTreePath *tp_new = gtk_tree_path_new_from_indices(indices[0] - 1, -1);

					if (tp_new) {
						if (gtk_tree_model_get_iter(tm, &itr_other, tp_new))
							can_swap = TRUE;
						gtk_tree_path_free(tp_new);
					}
				}

			gtk_tree_path_free(tp);
		}
	}
	else {
		can_swap = TRUE;
		gtk_tree_model_iter_next(tm, &itr_other);
	}

	if (can_swap) {
		gtk_list_store_swap(GTK_LIST_STORE(tm), itr, &itr_other);
		model_to_file(tm);
	}
}

void
query_tree_model_delete(GtkTreeModel *tm, GtkTreeIter *itr)
{
	gtk_list_store_remove(GTK_LIST_STORE(tm), itr);
	model_to_file(tm);
}
