; -*- coding: cp1251; -*-
; \todo Make script work correctly when 1.setup only for current user and 2.setup by one admin but removed by another.
;--------------------------------
; Constants
;--------------------------------
!define PLANS_PLANT_NAME "Plans Plant"
!define PLANS_PLANT_AUTHOR "Nick Slobodsky"
!define PLANS_PLANT_KEY "Software\${PLANS_PLANT_AUTHOR}\${PLANS_PLANT_NAME}"
!define PLANS_PLANT_VERSION "0.1.1"
!define QT_DIR "C:\tools\prog\Qt\4.6.2\w32"
!define QT_DLLS_DIR "${QT_DIR}\bin"
!define QT_TRANSLATIONS_DIR "${QT_DIR}\translations"
!define QT_PLUGINS_DIR "${QT_DIR}\plugins"
; !define VCREDIST_DIR "C:\Program Files (x86)\Microsoft SDKs\Windows\v6.0A\Bootstrapper\Packages\vcredist_x86"
;--------------------------------
!include "MUI.nsh"

; The name of the installer
Name $(PlansPlantName)
Caption $(PlansPlantTitle)
UninstallCaption $(PlansPlantUninstallTitle)
!define MUI_ICON "plansplant-install.ico"
!define MUI_UNICON "plansplant-uninstall.ico"

; The file to write
OutFile "plansplant-${PLANS_PLANT_VERSION}-w32-bin-sumo.exe"
; SetCompress off
; The default installation directory
InstallDir $PROGRAMFILES\PlansPlant

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM "Software\Nick Slobodsky\PlansPlant\Setup" "Install_Dir"

;--------------------------------
!define MUI_ABORTWARNING

Var MUI_TEMP
; Pages
  !define MUI_ABORTWARNING_TEXT $(PlansPlantSetupQuitConfirm)

  !define MUI_PAGE_HEADER_SUBTEXT $(PlansPlantLicenceSubheader)
  !insertmacro MUI_PAGE_LICENSE $(PlansPlantLicense)

  !define MUI_PAGE_HEADER_SUBTEXT $(PlansPlantFolderSubheader)
  !define MUI_DIRECTORYPAGE_TEXT_TOP $(PlansPlantFolderDescription)
   DirText "" "" "" $(PlansPlantFolderDialogPrompt)
  !insertmacro MUI_PAGE_DIRECTORY
  
  ;Start Menu Folder Page Configuration
  Var STARTMENU_FOLDER
  !define MUI_STARTMENUPAGE_REGISTRY_ROOT "HKCU" 
  !define MUI_STARTMENUPAGE_REGISTRY_KEY "Software\Nick Slobodsky\PlansPlant\Setup"
  !define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "Start Menu Folder"
  
  !define MUI_STARTMENUPAGE_DEFAULTFOLDER "$(PlansPlantName)"
  !insertmacro MUI_PAGE_STARTMENU Application $STARTMENU_FOLDER
  
  !define MUI_PAGE_HEADER_SUBTEXT $(PlansPlantInstallProgressSubheader)
  !insertmacro MUI_PAGE_INSTFILES
  
  !define MUI_PAGE_HEADER_TEXT $(PlansPlantUninstallTitle)
  !define MUI_PAGE_HEADER_SUBTEXT $(PlansPlantUninstallSubheader)
  !define MUI_UNCONFIRMPAGE_TEXT_TOP $(PlansPlantUninstallDescription)
  !insertmacro MUI_UNPAGE_CONFIRM

  !define MUI_PAGE_HEADER_SUBTEXT $(PlansPlantUninstallProgress)
  !insertmacro MUI_UNPAGE_INSTFILES
;--------------------------------
  !insertmacro MUI_LANGUAGE "English" ; first language is the default language
  !insertmacro MUI_LANGUAGE "Russian"
  LicenseLangString PlansPlantLicense ${LANG_ENGLISH} "..\COPYING"
  LicenseLangString PlansPlantLicense ${LANG_RUSSIAN} "COPYING.ru"

  LangString PlansPlantName ${LANG_ENGLISH} "${PLANS_PLANT_NAME}"
  LangString PlansPlantName ${LANG_RUSSIAN} " "
  LangString PlansPlantAuthor ${LANG_ENGLISH} "${PLANS_PLANT_AUTHOR}"
  LangString PlansPlantAuthor ${LANG_RUSSIAN} " "
  LangString PlansPlantUninstall ${LANG_ENGLISH} "Uninstall"
  LangString PlansPlantUninstall ${LANG_RUSSIAN} "   "
  LangString PlansPlantFileDescription ${LANG_ENGLISH} "Plans Plant document"
  LangString PlansPlantFileDescription ${LANG_RUSSIAN} ' " "'
  LangString PlansPlantDescription ${LANG_ENGLISH} "Program for tasks planning"
  LangString PlansPlantDescription ${LANG_RUSSIAN} "   "

  ; Defaults replacements because of cases in Russian 
  LangString PlansPlantTitle ${LANG_ENGLISH} "${PLANS_PLANT_NAME} Setup"
  LangString PlansPlantTitle ${LANG_RUSSIAN} ' " "'
  LangString PlansPlantLicenceSubheader ${LANG_RUSSIAN} '  " "    .'
  LangString PlansPlantLicenceSubheader ${LANG_ENGLISH} 'Please review the license terms before installing Plans Plant.'
  LangString PlansPlantSetupQuitConfirm ${LANG_RUSSIAN} '     " "?'
  LangString PlansPlantSetupQuitConfirm ${LANG_ENGLISH} "Are you sure you want to quit Plans Plant Setup?"
  LangString PlansPlantFolderSubheader ${LANG_RUSSIAN} '    " ".'
  LangString PlansPlantFolderSubheader ${LANG_ENGLISH} "Choose the folder in wich to install Plans Plant."
  LangString PlansPlantFolderDescription ${LANG_RUSSIAN} '  " "   .      ,   ""   .   ""  .'
  LangString PlansPlantFolderDescription ${LANG_ENGLISH} "Setup will install Plans Plant in the following folder. To install in a different folder, click Browse and select another folder. Click Next to continue."
  LangString PlansPlantFolderDialogPrompt ${LANG_RUSSIAN} '    " ":'
  LangString PlansPlantFolderDialogPrompt ${LANG_ENGLISH} "Select the folder to install Plans Plant in:"
  LangString PlansPlantInstallProgressSubheader ${LANG_RUSSIAN} ',    " "...'
  LangString PlansPlantInstallProgressSubheader ${LANG_ENGLISH} "Please wait while Plans Plant is being installed."

  LangString PlansPlantUninstallTitle ${LANG_RUSSIAN} ' " "' ; (   )
  LangString PlansPlantUninstallTitle ${LANG_ENGLISH} "Plans Plant Uninstall"
  LangString PlansPlantUninstallSubheader ${LANG_RUSSIAN} ' " "  .'
  LangString PlansPlantUninstallSubheader ${LANG_ENGLISH} "Remove Plans Plant from your computer."
  LangString PlansPlantUninstallDescription ${LANG_RUSSIAN} ' " "     .   "",   .'
  LangString PlansPlantUninstallDescription ${LANG_ENGLISH} "Plans Plant will be uninstalled from the following folder. Click Uninstall to start the uninstallation."
  LangString PlansPlantUninstallProgress ${LANG_RUSSIAN} ',    " "...'
  LangString PlansPlantUninstallProgress ${LANG_ENGLISH} "Please wait while Plans Plant is being uninstalled."
  
  !insertmacro MUI_RESERVEFILE_LANGDLL

  Var PlansPlantShortcut

; The stuff to install
Section "Plans Plant (required)"

  SectionIn RO
  SetShellVarContext all

  SetOutPath $TEMP
  SetOverwrite on
  File "..\..\setups\vc90crt\vc90crt\Release\vc90crt.msi"
  ExecWait "MsiExec.exe /q /i vc90crt.msi"
  Delete "$TEMP\vc90crt.msi"
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; Put file there
  File "..\release\plansplant.exe"
  File "..\release\plansplant-${PLANS_PLANT_VERSION}.dll"
  File "..\..\timeshop-0.3.1-3\timeshop\release\timeshop-0.3.1.dll"
  File "${QT_DLLS_DIR}\QtCore4.dll"
  File "${QT_DLLS_DIR}\QtGui4.dll"
  File "${QT_DLLS_DIR}\QtSvg4.dll"
  File "${QT_DLLS_DIR}\phonon4.dll"
  File "${QT_TRANSLATIONS_DIR}\qt_ru.qm"
  SetOutPath $INSTDIR\phonon_backend
  File "${QT_PLUGINS_DIR}\phonon_backend\phonon_ds94.dll"
  SetOutPath $INSTDIR\imageformats
  File "${QT_PLUGINS_DIR}\imageformats\qsvg4.dll"
  
  ; Write the installation path into the registry
  WriteRegStr HKLM "SOFTWARE\Nick Slobodsky\PlansPlant\Setup" "Install_Dir" "$INSTDIR"
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\PlansPlant" "DisplayName" $(PlansPlantName)
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\PlansPlant" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\PlansPlant" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\PlansPlant" "NoRepair" 1
  WriteUninstaller "uninstall.exe"
  ; Associate document files
  WriteRegStr HKCR "PlansPlant.Document" "" '$(PlansPlantFileDescription)'
  ; WriteRegStr HKCR "PlansPlant.Document\DefaultIcon" "" "$INSTDIR\plansplant.exe,1"
  WriteRegStr HKCR "PlansPlant.Document\shell\open\command" "" '"$INSTDIR\plansplant.exe" "%1"'
  WriteRegStr HKCR ".plansplant" "" "PlansPlant.Document"
  
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
    
  ; Create shortcuts
  CreateDirectory "$SMPROGRAMS\$STARTMENU_FOLDER"
  ; Program shortcut
  StrCpy $PlansPlantShortcut "$(PlansPlantName)"
  CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\$PlansPlantShortcut.lnk" "$INSTDIR\plansplant.exe" "" "$INSTDIR\plansplant.exe" 0 SW_SHOWNORMAL "" "$(PlansPlantDescription)"
  WriteRegStr HKLM "SOFTWARE\Nick Slobodsky\PlansPlant\Setup" "Program_Shortcut" "$PlansPlantShortcut"
  ; Uninstall shortcut
  StrCpy $PlansPlantShortcut "$(PlansPlantUninstall)"
  CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\$PlansPlantShortcut.lnk" "$INSTDIR\Uninstall.exe" 
  WriteRegStr HKLM "SOFTWARE\Nick Slobodsky\PlansPlant\Setup" "Uninstall_Shortcut" "$PlansPlantShortcut"
  
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

;--------------------------------
; Uninstaller
Section "Uninstall"

  SetShellVarContext all

  ; Remove files and uninstaller
  Delete $INSTDIR\plansplant.exe
  Delete $INSTDIR\timeshop-0.3.1.dll
  Delete $INSTDIR\plansplant-${PLANS_PLANT_VERSION}.dll
  Delete $INSTDIR\qt_ru.qm
  Delete $INSTDIR\imageformats\qsvg4.dll
  RMDir "$INSTDIR\imageformats"
  Delete $INSTDIR\phonon_backend\phonon_ds94.dll
  RMDir "$INSTDIR\phonon_backend"
  Delete $INSTDIR\phonon4.dll
  Delete $INSTDIR\QtSvg4.dll
  Delete $INSTDIR\QtCore4.dll
  Delete $INSTDIR\QtGui4.dll
  Delete $INSTDIR\uninstall.exe
  RMDir "$INSTDIR"
  ExecWait "MsiExec.exe /q /X{C6A18749-6944-47F9-985C-323312C74A99}"

  !insertmacro MUI_STARTMENU_GETFOLDER Application $MUI_TEMP

  ReadRegStr $PlansPlantShortcut HKLM "SOFTWARE\Nick Slobodsky\PlansPlant\Setup" "Program_Shortcut"
  Delete "$SMPROGRAMS\$MUI_TEMP\$PlansPlantShortcut.lnk"
  ReadRegStr $PlansPlantShortcut HKLM "SOFTWARE\Nick Slobodsky\PlansPlant\Setup" "Uninstall_Shortcut"
  DetailPrint "Delete $SMPROGRAMS\$MUI_TEMP\$PlansPlantShortcut.lnk"
  Delete "$SMPROGRAMS\$MUI_TEMP\$PlansPlantShortcut.lnk"
 
  ; Delete empty start menu parent diretories
  StrCpy $MUI_TEMP "$SMPROGRAMS\$MUI_TEMP"
 
  startMenuDeleteLoop:
    ClearErrors
    RMDir $MUI_TEMP
    GetFullPathName $MUI_TEMP "$MUI_TEMP\.."
    
    IfErrors startMenuDeleteLoopDone
  
    StrCmp $MUI_TEMP $SMPROGRAMS startMenuDeleteLoopDone startMenuDeleteLoop
  startMenuDeleteLoopDone:

  DeleteRegKey HKCR ".plansplant"
  DeleteRegKey HKCR "PlansPlant.Document"
  DeleteRegKey HKCU "Software\Nick Slobodsky\Plans Plant"
  DeleteRegKey /ifempty HKCU "Software\Nick Slobodsky"
  DeleteRegKey HKLM "Software\Nick Slobodsky\Plans Plant"
  DeleteRegKey /ifempty HKLM "Software\Nick Slobodsky"

  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\PlansPlant"
SectionEnd

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Function un.onInit
  !insertmacro MUI_UNGETLANGUAGE
FunctionEnd